*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE STCOPY (STRIN, STROUT, NC)
*
*
* Purpose:
*     Copy a string, checking for truncation
*
*
* Description:
*     This routines copies the input character string to the output
*     character string.  The number of characters copied is returned.
*     If the input string is shorter than the output string, the
*     remaining part of the output string is padded with blanks.  If
*     the input string is longer than the output string, a warning
*     message is signalled and the string is truncated to the output
*     length.
*
*
* Parameters:
* C ->  STRIN  - Input character string
* C <-  STROUT - Output character string
* I <-  NC     - Number of characters in the output string (at most
*                LEN(STROUT))
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:38:14 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE STCOPY (STRIN, STROUT, NC)


      INTEGER NC
      INTEGER NCI,NCO

      CHARACTER*(*) STRIN,STROUT


* Copy the string
      NCI=LEN(STRIN)
      NCO=LEN(STROUT)
      STROUT=STRIN

* Check for a truncated string
      IF (NCI.GT.NCO) THEN
        CALL HALT('STCOPY - String truncated')
        NC=NCO
      ELSE
        NC=NCI
      END IF


      RETURN

      END
