*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE RDRVAL (LINE, MINN, MAXN, VAL, N)
*
*
* Purpose:
*     Decode real values (variable number)
*
*
* Description:
*     This routine decodes a string containing numeric data.  Multiple
*     data items in the string are separated by commas or white space
*     (blanks, tabs or null characters).  The decoded data is stored as
*     real values.  If the number of data values in the string is less
*     than a given minimum number or a decoding error is detected, an
*     error message is printed and N is set to zero.  Warning messages
*     are printed if a null data value is encountered (interpreted as
*     zero), or extra data follows the requested values (this data is
*     ignored).
*
*
* Parameters:
* C ->  LINE   - Input string.  Blanks in the string are ignored.
* I ->  MINN   - Minimum number of values to be read (may be zero)
* I ->  MAXN   - Maximum number of values to be read (at most 256)
* R <-  VAL    - Array of MAXN elements used to store the values.  Only
*                the first N values are modified. If an error condition
*                is detected, the array VAL is not modified.  An error
*                condition occurs if too few values are specified or if
*                a decoding error is detected.
* I <-  N      - Actual number of values read.  If an error condition
*                is detected, N is set to zero.  An error condition
*                occurs if too few values are specified or if a
*                decoding error is detected.  N is also set to zero if
*                the number of values to be read is allowed to be zero
*                and the input string contains only white space.
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.6 $  $Date: 1995/03/08 15:38:02 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE RDRVAL (LINE, MINN, MAXN, VAL, N)


      CHARACTER*(*) PRETXT
      INTEGER MXMAXN,MXNE,MXCHAR
      PARAMETER (MXMAXN=256,MXNE=72,MXCHAR=20)
      PARAMETER (PRETXT='RDRVAL - Error in data format, data: ')

      INTEGER MINN,MAXN,N
      INTEGER M,I,IS,IE,IER,LENP,NCE
      INTEGER IST(MXMAXN+1),IFN(MXMAXN+1)

      CHARACTER*(*) LINE
      CHARACTER*(MXNE) ERRTXT

      REAL VAL(MAXN)
      REAL TEMP(MXMAXN)


* Find the substrings
      CALL FNDSUB(LINE,' ',IST,IFN,MXMAXN+1,M)

* Check the number of values found
      N=0
      IF (M.LT.MINN) THEN
        CALL WARN('RDRVAL - Error, too few data values')

      ELSE IF (M.GT.MXMAXN .AND. MAXN.GT.MXMAXN) THEN
        CALL WARN('RDRVAL - Error, too many data values')

      ELSE

        IF (M.GT.MAXN) THEN
          CALL WARN('RDRVAL - Warning, extra data ignored')
          M=MAXN
        END IF

* Decode the substrings
        DO 220 I=1,M
          IS=IST(I)
          IE=IFN(I)
          IF (IS.LE.IE) THEN
            IF (IE-IS+1.LE.MXCHAR) THEN
              READ (UNIT=LINE(IS:IE),FMT=1000,IOSTAT=IER) TEMP(I)
            ELSE
              IER=1
            END IF

* Error messages
            IF (IER.NE.0) THEN
              LENP=LEN(PRETXT)
              NCE=LENP+IE-IS+1+2
              IF (NCE.LE.MXNE) THEN
                ERRTXT=PRETXT//'"'//LINE(IS:IE)//'"'
              ELSE
                ERRTXT=PRETXT//'"'//LINE(IS:IS+MXNE-LENP-6)//'..."'
                NCE=MXNE
              END IF
              CALL WARN(ERRTXT(1:NCE))
              GO TO 300
            END IF

          ELSE
            CALL WARN('RDRVAL - Warning, null data value')
            TEMP(I)=0.0

          END IF

 220    CONTINUE

        N=M
        CALL VCOPY(TEMP,VAL,N)

      END IF


 300  RETURN

 1000 FORMAT (E20.0)

      END
