*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE RDRVA2 (LINE, VAL1, VAL2, IER)
*
*
* Purpose:
*     Decode two real values
*
*
* Description:
*     This routine decodes a string containing numeric data.  The two
*     data values in the string are separated by a comma and/or white
*     space (blanks, tabs or null characters).  The decoded data is
*     stored as real values.  If an error is detected (decoding error,
*     too few values, or too many values), an error flag is set.
*
*
* Parameters:
* C ->  LINE   - Input string.  Blanks in the string are ignored.
* R <-  VAL1   - First real value.  This value is not set in case of an
*                error.
* R <-  VAL2   - Second real value.  This value is not set in case of
*                an error.
* I <-  IER    - Error code,
*                0 - No error
*                1 - Error
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:37:51 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE RDRVA2 (LINE, VAL1, VAL2, IER)


      INTEGER IER
      INTEGER NV

      CHARACTER*(*) LINE

      REAL VAL1,VAL2
      REAL VT(2)


* Use RDRVAL to decode the values
      CALL RDRVAL(LINE,2,2,VT,NV)
      IF (NV.EQ.2) THEN
        VAL1=VT(1)
        VAL2=VT(2)
        IER=0
      ELSE
        IER=1
      END IF


      RETURN

      END
