*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE RDRVA1 (LINE, VAL, IER)
*
*
* Purpose:
*     Decode a real value
*
*
* Description:
*     This routine decodes a string containing a numeric value.  The
*     decoded datum is stored as a real value.  If an error is detected
*     (decoding error, too few values, or too many values), an error
*     flag is set.
*
*
* Parameters:
* C ->  LINE   - Input string.  Blanks in the string are ignored.
* R <-  VAL    - Output real value.  This value is not set in case of
*                an error.
* I <-  IER    - Error code,
*                0 - No error
*                1 - Error
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:37:47 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE RDRVA1 (LINE, VAL, IER)


      INTEGER IER
      INTEGER NV

      CHARACTER*(*) LINE

      REAL VAL
      REAL VT(1)


* Use RDRVAL to decode the value
      CALL RDRVAL(LINE,1,1,VT,NV)
      IF (NV.EQ.1) THEN
        VAL=VT(1)
        IER=0
      ELSE
        IER=1
      END IF


      RETURN

      END
