*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE RDIVA2 (LINE, IVAL1, IVAL2, IER)
*
*
* Purpose:
*     Decode two integer values
*
*
* Description:
*     This routine decodes a string containing numeric data.  The two
*     data values in the string are separated by a comma and/or white
*     space (blanks, tabs or null characters).  The decoded data is
*     stored as integer values.  If an error is detected (decoding
*     error, too few values, or too many values), an error flag is set.
*
*
* Parameters:
* C ->  LINE   - Input string.  Blanks in the string are ignored.
* I <-  IVAL1  - First integer value.  This value is not set in case of
*                an error.
* I <-  IVAL2  - Second integer value.  This value is not set in case
*                of an error.
* I ->  IER    - Error code,
*                0 - No error
*                1 - Error
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:37:36 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE RDIVA2 (LINE, IVAL1, IVAL2, IER)


      INTEGER IVAL1,IVAL2,IER
      INTEGER NV
      INTEGER IVT(2)
      CHARACTER*(*) LINE


* Use RDIVAL to decode the values
      CALL RDIVAL(LINE,2,2,IVT,NV)
      IF (NV.EQ.2) THEN
        IVAL1=IVT(1)
        IVAL2=IVT(2)
        IER=0
      ELSE
        IER=1
      END IF


      RETURN

      END
