*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE STRPAR (STRIN, STROUT, NC)
*
*
* Purpose:
*     Remove outer parentheses from a string
*
*
* Description:
*     This routine copies an input string omitting leading and trailing
*     white space (blank, tab or null characters) and any outer
*     parentheses.  Only the outer parentheses are removed.  White
*     space inside these parentheses is included in the output string.
*
*
* Parameters:
* C ->  STRIN  - Input string
* C <-  STROUT - Output string
* I <-  NC     - Number of characters in the output string
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:41:33 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE STRPAR (STRIN, STROUT, NC)


      CHARACTER*(*) STRIN,STROUT

      INTEGER NC,IST,IFN
      INTEGER LOCNBL,LENSTR


* Find the substring to be copied
      IFN=LENSTR(STRIN)
      IST=1

      IF (IFN.GT.0) THEN
        IST=LOCNBL(STRIN(1:IFN))
        IF (IST.LT.IFN) THEN
          IF (STRIN(IST:IST).EQ.'(' .AND. STRIN(IFN:IFN).EQ.')') THEN
            IST=IST+1
            IFN=IFN-1
          END IF
        END IF
      END IF

* Copy the selected part of the input string
      IF (IST.LE.IFN) THEN
        CALL STCOPY(STRIN(IST:IFN),STROUT,NC)
      ELSE
        STROUT=' '
        NC=0
      END IF


      RETURN

      END
