*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE PRMENU (CHTAB, NOENT, IWIDTH)
*
*
* Purpose:
*     Print a menu of keywords
*
*
* Description:
*     This routine writes character strings to standard output with the
*     strings aligned in fields of a given width.  The number of fields
*     is determined such as to fit into a total width of 70 characters.
*     If a string exceeds the field width, it spills over into the
*     next field, displacing the next string into a following field.
*     Strings that are longer than two field widths are truncated and
*     the last portion of the string is replaced by '...'.
*
*
* Parameters:
* C ->  CHRTAB - Array of character strings
* I ->  NOENT  - Number of character strings to be printed
* I ->  IWIDTH - Field width in characters (at least 2)
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.5 $  $Date: 1995/03/08 15:41:31 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE PRMENU (CHRTAB, NOENT, IWIDTH)


      INTEGER ICS,NCMX
      PARAMETER (ICS=3,NCMX=72)

      INTEGER NOENT,IWIDTH
      INTEGER LENSTR,ICEIL,LENBLK
      INTEGER MXWID,IC,K,NK,NC

      CHARACTER LINE*(NCMX),CHRTAB(NOENT)*(*)


      MXWID=MIN(2*IWIDTH-1,NCMX-ICS+1)
      LINE=' '

* Loop over the number of strings
      IC=ICS
      DO 100 K=1,NOENT

* Determine how many characters are needed to print the string
        NK=LENSTR(CHRTAB(K))
        NC=ICEIL(MIN(NK+1,MXWID),IWIDTH)*IWIDTH

* If necessary, print a line
        IF (IC+NC.GT.NCMX) THEN
          WRITE (UNIT=*,FMT=1000) LINE(1:LENBLK(LINE))
          IC=ICS
        END IF

* Insert a new string into the line
        IF (NK.LE.MXWID) THEN
          LINE(IC:)=CHRTAB(K)(1:NK)
        ELSE
          LINE(IC:)=CHRTAB(K)(1:MXWID-3)//'...'
        END IF
        IC=IC+NC

 100  CONTINUE

* Print the last line
      WRITE (UNIT=*,FMT=1000) LINE(1:LENBLK(LINE))


      RETURN

 1000 FORMAT (A)

      END
