*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE PPARST (LINEI, KEYWRD, LK, TOKEN, LT, LLINE, LL,
*                        RLINE)
*
*
* Purpose:
*     Extract a keyword and token string from a string
*
*
* Description:
*     String Processing:
*     1) This routine looks for a separator consisting of a comma
*        and/or whitespace not in parentheses or quotes.  This
*        separator separates the input string into a left part and a
*        right part.  If no separator is found, the left part is the
*        whole string and the right part is null.
*     2) The left part of the input string is parsed into a keyword
*        string and a token string separated by an equal sign.  If no
*        equal sign is found, the token string is considered to be
*        null. The keyword string is returned as KEYWRD and the token
*        string as TOKEN.  Leading and trailing white space are removed
*        from TOKEN and KEYWRD.
*     3) The left side of the string is returned (after some editing)
*        as LLINE.  This string includes the keyword string, the equal
*        sign delimiter and the token string.  White space surrounding
*        the keyword string and token string is removed, and white
*        space on either side of the equal sign (if any) is collapsed
*        into a single blank.
*     If the input string is " AAA  = BBB , CCC = DDD", after
*     processing:
*       KEYWRD="AAA",      LK=3
*       TOKEN="BBB",       LT=3
*       LLINE="AAA = BBB", LL=9
*       RLINE="CCC = DDD"
*
*
* Parameters:
* C ->  LINEI  - Input string
* C <-  KEYWRD - Keyword string
* I <-  LK     - Length of the keyword string
* C <-  TOKEN  - Token string
* I <-  LT     - Length of the token string
* C <-  LLINE  - Keyword string, equal sign delimiter and token string
* I <-  LL     - Length of LLINE
* C <-  RLINE  - On return, RLINE is set to the input string with the
*                decoded first part removed.
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.6 $  $Date: 1995/03/08 15:41:28 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE PPARST (LINEI, KEYWRD, LK, TOKEN, LT, LLINE, LL,
     -                 RLINE)


      INTEGER LK,LT,LL
      INTEGER IS1,IE1,IS2,IE2,ISEP,NC,N

      CHARACTER*(*) LINEI,KEYWRD,TOKEN,LLINE,RLINE


* Parse the string
      CALL GTPSTE(LINEI,'""()',IS1,IE1,IS2,IE2,ISEP)

* Return the keyword string
      IF (IS1.LE.IE1) THEN
        CALL STCOPY(LINEI(IS1:IE1),KEYWRD,LK)
      ELSE
        KEYWRD=' '
        LK=0
      END IF

* Return the token string
      IF (IS2.LE.IE2) THEN
        CALL STCOPY(LINEI(IS2:IE2),TOKEN,LT)
      ELSE
        TOKEN=' '
        LT=0
      END IF

* Return the left side string (with some editing)
* - the keyword string is LINEI(IS1:IE1)
* - the equal sign delimiter (with enclosing white space) is
*   LINEI(IE1+1:max(IS2-1,IE1))
* - collapse the white space surrounding the equal sign
* - the token string is LINEI(IS2:IE2)
      LL=0
      IF (IS1.LE.IE1) THEN
        CALL STCOPY(LINEI(IS1:IE1),LLINE,NC)
        LL=LL+NC
      END IF
      N=(IS2-1)-(IE1+1)+1
      IF (N.GT.0) THEN
        CALL CMPRWS(LINEI(IE1+1:IS2-1),LLINE(LL+1:LL+N),NC)
        LL=LL+NC
      END IF
      N=IE2-IS2+1
      IF (N.GT.0) THEN
        CALL STCOPY(LINEI(IS2:IE2),LLINE(LL+1:LL+N),NC)
        LL=LL+NC
      END IF
      IF (LL.LE.LEN(LLINE)) LLINE(LL+1:)=' '

* Return the right side string
      IF (ISEP.LE.LEN(LINEI)) THEN
        CALL STCOPY(LINEI(ISEP+1:),RLINE,NC)
      ELSE
        RLINE=' '
      END IF


      RETURN

      END
