*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE GTPSTE (STRING, QCHARS, IS1, IE1, IS2, IE2, ISEP)
*
*
* Purpose:
*     Parse a string with equal sign and comma separators
*
*
* Description:
*     This routine finds the first occurrence of separator strings in
*     an input string.  A separator string occurs between substrings in
*     the original string and consists of either white space separator
*     or a comma separator.  A white space separator consists entirely
*     of white space (blanks, tabs or null characters).  A comma
*     separator consists of a comma, optionally surrounded by white
*     space.  An equal sign separator consists of an equal sign with
*     optional surrounding white space.  A white space separator cannot
*     occur at the beginning or end of the input string.
*
*     Optionally paired quote characters can be specified to allow
*     white space and the separator character to appear in the string
*     without acting as separators.
*
*     The string syntax is " AAAA  = BBBB [,] CCCC..."
*
*     The non-blank extent of the string before the equal sign is
*     STRING(IS1:IE1), with the possibility that the substring has a
*     zero length (IE1=IS1-1).  The non-blank extent of the string
*     after the equal but before the comma or whitespace separator is
*     STRING(IS2:IE2), with the possibility that the substring has zero
*     length (IE2=IS2-1).  The whitespace surrounded equal sign
*     delimiter is in the substring STRING(IE1+1:IS2-1).  However, if
*     an equal sign delimiter is not found, the substring limits may
*     indicate a zero or negative length.  The last character in the
*     comma separator is STRING(ISEP:ISEP).  If a separator is not
*     found, ISEP is set to LEN(STRING)+1.  If a separator is found,
*     the non-blank portion of the string following the separator
*     starts with STRING(ISEP+1:ISEP+1).
*
*     String                       IS1  IE1  IS2  IE2 ISEP
*     "  AAAA = BBBB , CCCC...."    3    6   10   13   16
*     "  "                          1    0    1    0    3
*     "AAAA , CCCC"                 1    4    4    3    7
*     "AAAA(II II) = BBB  CCCC"     1   11   15   17   19
*     "AAAA       "                 1    4    4    3   12
*
*
* Parameters:
* C ->  STRING - Input character string
* C ->  QCHARS - Character string specifying pairs of quote characters
*                (the left and right quote characters).  For instance,
*                QCHARS='""()' specifies that double quotes and
*                parentheses serve as quote characters.  In the part of
*                the input string between a matched pair of quote
*                characters, any other characters, including quote
*                characters other than from the pair in question, are
*                treated as ordinary characters.  Up to 5 pairs of
*                quote characters can be specified.  A blank string
*                signifies no quote characters are to be recognized.
*                Trailing blanks in the string QCHARS are ignored.
* I <-  IS1    - Pointer to the characters that starts the non-blank
*                portion of the input string before the equal sign.
*                IS1 will be equal to 1 in the case of no non-blank
*                characters being found in front of an equal sign.
* I <-  IE1    - Pointer to the character that terminates the portion
*                of the input string before the equal sign.  Normally
*                IE1 will point to a non-blank character.  However, in
*                the case of no non-blank characters being found in
*                front of the equal sign, IE1 will be set to zero.
* I <-  IS2    - Pointer to the characters that starts the non-blank
*                portion of the input string after the equal sign.
* I <-  IE2    - Pointer to the character that terminates the portion
*                of the input string after the equal sign
* I <-  ISEP   - Pointer to the character that ends the separator.  In
*                the case of a separator with trailing white space,
*                ISEP points to the last white space character in the
*                separator.  In the case of no separator being found,
*                ISEP is equal to LEN(STRING)+1.
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.8 $  $Date: 1995/03/08 15:41:12 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE GTPSTE (STRING, QCHARS, IS1, IE1, IS2, IE2, ISEP)


      INTEGER IS1,IE1,IS2,IE2,ISEP
      INTEGER ITS,ITE,ISEP1,KK,ISEP2

      CHARACTER*(*) STRING,QCHARS


* Pick up the first delimiter, comma or equal sign
      CALL GTPSTR(STRING,',=',QCHARS,ITS,ITE,ISEP1)
      IS1=ITS
      IE1=ITE
      IF (ITE.GT.0) THEN
        IS2=ITE
      ELSE
        IS2=1
      END IF
      IE2=IS2-1
      ISEP=ISEP1


      IF (ISEP1.LE.LEN(STRING)) THEN

* If we found an equal sign, scan for a comma separator
        KK=INDEX(STRING(ITE+1:ISEP1),'=')
        IF (KK.NE.0) THEN
          CALL GTPSTR(STRING(ISEP1+1:),',',QCHARS,ITS,ITE,ISEP2)
          IS2=ITS+ISEP1
          IE2=ITE+ISEP1
          ISEP=ISEP2+ISEP1
        END IF

      END IF


      RETURN

      END
