*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE FNDSUB (LINE, QCHARS, IST, IFN, MAXN, N)
*
*
* Purpose:
*     Find comma/whitespace delimited substrings in a string
*
*
* Description:
*     This routine finds substrings in a given string.  Substrings
*     are separated by commas or white space (blanks, tabs or null
*     characters).  A warning message is printed if the maximum number
*     of substrings is found and data follows the last item found.
*     For each output substring, leading and trailing white space is
*     removed.
*
*     Optionally paired quote characters can be specified to allow
*     white space and the separator character to appear in the string
*     without acting as separators.
*
*
* Parameters:
* C ->  LINE   - Input string
* C ->  QCHARS - Character string specifying pairs of quote characters
*                (the left and right quote characters).  For instance,
*                QCHARS='""()' specifies that double quotes and
*                parentheses serve as quote characters.  In the part of
*                the input string between a matched pair of quote
*                characters, any other characters, including quote
*                characters other than from the pair in question, are
*                treated as ordinary characters.  Up to 5 pairs of
*                quote characters can be specified.  A blank string
*                signifies no quote characters are to be recognized.
*                Trailing blanks in the string QCHARS are ignored.
* I ->  MAXN   - Maximum permissible value for N
* I <-  IST    - Array of integer pointers (N values).  Element IST(i)
*                points to the start of substring i. Note that the last
*                element IST(N) will point to LEN(STRING)+1 if the last
*                substring is null.
* I <-  IFN    - Array of integer pointers (N values).  Element IFN(i)
*                points to the end of substring i.  Note that the first
*                element IFN(1) can point to 0 if the first substring
*                is null.
* I <-  N      - Number of substrings found.  Some of these substrings
*                may be null.  A null substring is signalled by having
*                IFN(i)=IST(i)-1 for substring i.
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.5 $  $Date: 1995/03/08 15:41:09 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE FNDSUB (LINE, QCHARS, IST, IFN, MAXN, N)


      INTEGER MAXN,N
      INTEGER IST(MAXN),IFN(MAXN)
      INTEGER ISEP,NCHR,IPTR,IS1,IE1

      CHARACTER*(*) LINE,QCHARS


* Initialization
      N=0
      ISEP=0
      NCHR=LEN(LINE)

 100  IF (ISEP.LT.NCHR .AND. N.LT.MAXN) THEN

* Find a separator not within quotes
        IPTR=ISEP+1
        CALL GTPSTR(LINE(IPTR:),',',QCHARS,IS1,IE1,ISEP)
        IS1=IS1+IPTR-1
        IE1=IE1+IPTR-1
        ISEP=ISEP+IPTR-1

* Save the pointers to the string
        IF (IS1.LE.IE1 .OR. ISEP.LE.NCHR) THEN
          N=N+1
          IST(N)=IS1
          IFN(N)=IE1
        END IF

      GO TO 100
      END IF

* String exhausted, check for a final null substring
      IF (NCHR.GT.0 .AND. N.LT.MAXN .AND. ISEP.EQ.NCHR) THEN
        N=N+1
        IST(N)=NCHR+1
        IFN(N)=NCHR
      END IF


      RETURN

      END
