*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE CMPRWS (STRING, CSTR, NC)
*
*
* Purpose:
*     Collapse white space in a string to a single blank
*
*
* Description:
*     This subroutine copies an input string to an output string,
*     collapsing contiguous white space characters (blanks, tabs and
*     null characters to a single blank.
*
*
* Parameters:
* C ->  STRING - Input string
* C <-  CSTR   - Output string, padded with trailing blanks
* I <-  NC     - Number of characters in CSTR, maximum LEN(STRING)
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:41:06 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE CMPRWS (STRING, CSTR, NC)


      INTEGER NC
      INTEGER K,LC,I


      LOGICAL WS

      CHARACTER*(*) STRING,CSTR
      CHARACTER*1 CH


* Collapse white space at beginning or in middle
      WS=.FALSE.
      K=0
      LC=LEN(CSTR)
      DO 100 I=1,LEN(STRING)
        CH=STRING(I:I)
        IF (CH.EQ.' ' .OR. CH.EQ.CHAR(9) .OR. CH.EQ.CHAR(0)) THEN
          WS=.TRUE.
        ELSE
          IF (WS) THEN
            K=K+1
            IF (K.LE.LC) CSTR(K:K)=' '
            WS=.FALSE.
          END IF
          K=K+1
          IF (K.LE.LC) CSTR(K:K)=CH
        END IF
 100  CONTINUE

* Add whitespace at end if appropriate
      IF (WS) THEN
        K=K+1
        IF (K.LE.LC) CSTR(K:K)=' '
      END IF

* Return the length of the string
      IF (K.GT.LC) CALL HALT('CMPRWS - String truncated')
      NC=K


      RETURN

      END
