*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     INTEGER FUNCTION LOCNBL (LINE)
*
*
* Purpose:
*     Find the first non-whitespace character in a string
*
*
* Description:
*     This function returns a pointer to the first significant
*     character in a string.  Blanks, tabs and null characters are
*     not considered to be significant.
*
*
* Parameters:
* I <-  LOCNBL - The returned function value is a pointer to the first
*                significant character in the input string.  If none is
*                found, LOCNBL is equal to one more than the length of
*                the input string.
*
* C ->  LINE   - Input character string
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:37:20 $
*
*
*-----------------------------------------------------------------------

      INTEGER FUNCTION LOCNBL (LINE)


      INTEGER NCHR,L

      CHARACTER*(*) LINE


* Find the first significant character
      NCHR=LEN(LINE)
      DO 100 L=1,NCHR
        IF (LINE(L:L).NE.' ' .AND. LINE(L:L).NE.CHAR(9)
     -      .AND. LINE(L:L).NE.CHAR(0)) GO TO 200
 100  CONTINUE

* Return the pointer to the first significant character
 200  LOCNBL=L


      RETURN

      END
