*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     INTEGER FUNCTION LENSTR (LINE)
*
*
* Purpose:
*     Find the length of a whitespace terminated string
*
*
* Description:
*     This function returns the number of characters in a string up to
*     the last significant character.  Blanks, tabs and null characters
*     are not considered to be significant.
*
*
* Parameters:
* I <-  LENSTR - The returned function value is the number of
*                characters in the character string, not including
*                trailing blanks, tabs or null characters
*
* C ->  LINE   - Input character string
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:37:17 $
*
*
*-----------------------------------------------------------------------

      INTEGER FUNCTION LENSTR (LINE)


      INTEGER NCHR,L

      CHARACTER*(*) LINE


* Find the last significant character
      NCHR=LEN(LINE)
      DO 100 L=NCHR,1,-1
        IF (LINE(L:L).NE.' ' . AND. LINE(L:L).NE.CHAR(9)
     -      .AND. LINE(L:L).NE.CHAR(0)) GO TO 200
 100  CONTINUE

* Return the pointer to the last significant character
 200  LENSTR=L


      RETURN

      END
