*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     INTEGER FUNCTION LENBLK (LINE)
*
*
* Purpose:
*     Find the length of a blank terminated string
*
*
* Description:
*     This function returns the number of characters in a string up
*     to the last significant character.  Trailing blanks are not
*     considered to be significant.
*
*
* Parameters:
* I <-  LENBLK - The returned function value is the number of
*                characters in the character string, not including
*                trailing blanks
*
* C ->  LINE   - Input character string
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.2 $  $Date: 1995/03/08 15:37:10 $
*
*
*-----------------------------------------------------------------------

      INTEGER FUNCTION LENBLK (LINE)


      INTEGER NCHR,L

      CHARACTER*(*) LINE


* Find the last non-blank character
      NCHR=LEN(LINE)
      DO 100 L=NCHR,1,-1
        IF (LINE(L:L).NE.' ') GO TO 200
 100  CONTINUE

* Return the pointer to the last significant character
 200  LENBLK=L


      RETURN

      END
