*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     INTEGER FUNCTION KEYMAT (STRIN, KEYTAB, NOKEY)
*
*
* Purpose:
*     Match keyword strings (case sensitive)
*
*
* Description:
*     This subroutine searches a table for a match to a character
*     string.  The table of keywords is searched for the first match.
*     White space (blanks, tabs or null characters) at the end
*     of either the input string or the keyword strings is not
*     significant.  Upper and lower case strings and keywords are
*     treated as being distinct.
*
*
* Parameters:
* I <-  KEYMAT - Output index of the matched keyword.  KEYMAT is set to
*                0 if no match was found.
*                   0 - No match
*                   1 - Match to the first keyword
*                   2 - Match to the second keyword
*                       ...
*
* C ->  STRIN  - Input character string
* C ->  KEYTAB - Character array containing the candidate keywords.
*                An optional asterisk ('*') is used to indicate the
*                minimum number of characters needed for a match.
*                A second asterisk can be used to indicate that
*                characters in the input string after this point need
*                not match.
*                Example: Keyword table entry 'ABC*DE*F'.
*                  - Input strings 'ABC', 'ABCD', 'ABCDE', and 'ABCDEx'
*                    match this entry.
*                  - Input strings 'AB', 'ABc', ' ABC', and 'ABCX' do
*                    not match this entry.
* I ->  NOKEY  - Number of keywords in the keyword array
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:37:03 $
*
*
*-----------------------------------------------------------------------

      INTEGER FUNCTION KEYMAT (STRIN, KEYTAB, NOKEY)


      INTEGER NOKEY
      CHARACTER*(*) KEYTAB(NOKEY),STRIN

      INTEGER LENSTR
      INTEGER LENI,I,LENK,K,L,LI


      LENI=LENSTR(STRIN)
      DO 100 I=1,NOKEY

* Find the positions of the *'s in the keyword
* K points to the first *, L points to the second *
        LENK=LENSTR(KEYTAB(I))
        K=INDEX(KEYTAB(I)(1:LENK),'*')

* Check for a match
* String matches are made only for strings with valid lengths
        IF (K.EQ.0) THEN

* No asterisks
          IF (LENI.EQ.LENK) THEN
            IF (STRIN(1:LENI).EQ.KEYTAB(I)(1:LENI)) GO TO 200
          END IF

        ELSE
          L=INDEX(KEYTAB(I)(K+1:LENK),'*')+K

* One asterisk
          IF (L.EQ.K) THEN
            IF (LENI.GE.K-1 .AND. LENI.LE.LENK-1) THEN
              IF (STRIN(1:K-1).EQ.KEYTAB(I)(1:K-1) .AND.
     -            STRIN(K:LENI).EQ.KEYTAB(I)(K+1:LENI+1)) GO TO 200
            END IF

* Two asterisks
          ELSE
            LI=MIN(LENI,L-2)
            IF (LI.GE.K-1) THEN
              IF (STRIN(1:K-1).EQ.KEYTAB(I)(1:K-1) .AND.
     -            STRIN(K:LI).EQ.KEYTAB(I)(K+1:LI+1)) GO TO 200
            END IF

          END IF

        END IF

 100  CONTINUE
      I=0

* Return the index of the match
 200  KEYMAT=I


      RETURN

      END
