*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE DECOFF (LINE, IPAR)
*
*
* Purpose:
*     Decoder ON/OFF keywords
*
*
* Description:
*     The keywords are decoded from an input string.  The valid
*     keywords are
*       null or ON
*       OFF
*
*
* Parameters:
* C <-> LINE   - Character string.  The string is set to blanks on
*                return.
* I <-  IPAR   - Integer value.  IPAR is set to one for ON or a null
*                string and to zero for OFF.  If a keyword match is not
*                found, IPAR is not set.
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:36:45 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE DECOFF (LINE, IPAR)


      INTEGER NEOFF
      PARAMETER (NEOFF=2)

      INTEGER IPAR
      INTEGER LENSTR
      INTEGER IFN,NC,N

      CHARACTER*(*) LINE,TD*1

      CHARACTER*3 OFFTAB(NEOFF)
      DATA OFFTAB/'*ON', 'OFF'/
      DATA IFN/0/


* Decode the keywords
      NC=1
 100  IF (NC.GT.0) THEN
        CALL FNDPAR(LINE,OFFTAB,NEOFF,TD(1:IFN),NC,N)
        IF (N.EQ.1) THEN
          IPAR=1
        ELSE IF (N.EQ.2) THEN
          IPAR=0
        END IF
        NC=LENSTR(LINE)
      GO TO 100
      END IF


      RETURN

      END
