*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE CONVIC (IVAL, STRING, NC)
*
*
* Purpose:
*     Convert an integer value to a string (trim blanks)
*
*
* Description:
*     This routine converts an integer value to a string.  Leading
*     blanks are trimmed from the string.
*
*
* Parameters:
* I ->  IVAL   - Integer value to be converted
* C <-  STRING - Output string corresponding to the integer value.
*                The representation of the value has a maximum of 10
*                characters left justified in the string.  Trailing
*                blanks, if necessary, pad out the string.
* I <-  NC     - Number of characters representing the integer value
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:36:43 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE CONVIC (IVAL, STRING, NC)


      INTEGER IVAL,NC
      INTEGER NS

      CHARACTER*(*) STRING
      CHARACTER*10 STRT


* Convert the integer to a string
      WRITE (UNIT=STRT,FMT=2000) IVAL

* Find the first non-blank character
      DO 100 NS=1,10
        IF (STRT(NS:NS).NE.' ') GO TO 120
 100  CONTINUE
      CALL HALT('CONVIC - Unexpected error')

* Copy the value string to the output string
 120  NC=11-NS
      CALL STCOPY(STRT(NS:10),STRING,NC)


      RETURN

 2000 FORMAT (I10)

      END
