*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE CONSTR (STRL, DELIM, STRR, STRO)
*
*
* Purpose:
*     Concatenate strings with an optional delimiter
*
*
* Description:
*     This routine generates an output string which is formed from a
*     left string, a delimiter string and a right string.  Trailing
*     blanks, tabs and nulls are ignored in the left and right string.
*     The delimiter is inserted as is between the left and right
*     strings.  However, if either the left string or the right string
*     is blank, the delimiter is omitted.
*
*     The output character string can appear also as the left or the
*     right string.  The maximum number of characters in the right
*     string is limited to 2048.
*
*
* Parameters:
* C ->  STRL   - Left character string
* C ->  DELIM  - Delimiter string
* C ->  STRR   - Right character string (maximum 2048 characters not
*                including trailing non-significant characters)
* C <-  STRO   - Output character string.  STRO is padded with blanks.
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:36:40 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE CONSTR (STRL, DELIM, STRR, STRO)


      INTEGER LTEMP
      PARAMETER (LTEMP=2048)

      INTEGER LL,LR,NT,NC
      INTEGER LENSTR

      CHARACTER*(*) STRL,DELIM,STRR,STRO
      CHARACTER*(LTEMP) TEMP


* Concatenate the strings
      LL=LENSTR(STRL)
      LR=LENSTR(STRR)
      IF (LL.GT.0 .AND. LR.GT.0) THEN
        NT=MIN(LR,LTEMP)
        TEMP(1:NT)=STRR(1:LR)
        STRO=STRL(1:LL)//DELIM//TEMP(1:NT)
        NC=LL+LEN(DELIM)+LR
      ELSE IF (LL.GT.0) THEN
        STRO=STRL(1:LL)
        NC=LL
      ELSE
        STRO=STRR(1:LR)
        NC=LR
      END IF

* Check the output length
      IF (NC.GT.LEN(STRO) .OR. LR.GT.LTEMP)
     -  CALL HALT('CONSTR - String truncated')


      RETURN

      END
