*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE XYDRAW (IX, IY)
*
*
* Purpose:
*     Draw a vector
*
*
* Description:
*     This subroutine draws a vector from the previous pen position
*     to a new pen position.  The width of the vector is set by the
*     routine SETPLW.
*       LWIDTH > 0 - Draw a visible vector using the vector rendition.
*                    The width of the line can only be varied for some
*                    plot devices.
*       LWIDTH = 0 - Move the plot pen without drawing a line
*       LWIDTH < 0 - Draw a visible vector using the background
*                    rendition.  On some devices, the action is the
*                    same as moving the plot pen without drawing a
*                    line.
*
*
* Parameters:
* R ->  IX     - X coordinate of the new pen position (0 to 4095)
* R ->  IY     - Y coordinate of the new pen position (0 to 4095)
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:29:08 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE XYDRAW (IX, IY)


      INTEGER IX,IY
      INTEGER LWIDTH

* Plot device flags common area
      LOGICAL PS,TK,UN,VT
      COMMON /DEVCOM/ PS,TK,UN,VT


      CALL GETPLW(LWIDTH)
      IF (PS) CALL PSXY(IX,IY,LWIDTH)
      IF (TK) CALL TKXY(IX,IY,LWIDTH)
      IF (UN) CALL UNXY(IX,IY,LWIDTH)
      IF (VT) CALL VTXY(IX,IY,LWIDTH)
      CALL SETPOS(IX,IY)


      RETURN

      END
