*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE XYDASH (IX1,IY1, IX2,IY2, IPATTN, K, REMAIN)
*
*
* Purpose:
*     Draw a dashed line
*
*
* Description:
*     The given points defining a vector are joined with a patterned
*     line.  The pattern consists of on/off segments of arbitrary
*     length.  No checking is done in this routine to determine if the
*     plotting will extend outside the bounds of the plotting device.
*
*
* Parameters:
* I ->  IX1,IY1 - X and Y coordinates of the start of the vector
*                 (plotting coordinates)
* I ->  IX2,IY2 - X and Y coordinates of the end of the vector
*                 (plotting coordinates)
* I ->  IPATTN - Line pattern.  This is a five element array describing
*                the line pattern to be used. The patterns are coded as
*                lengths of on and off segments.  A positive value
*                indicates on, while a negative value indicates off.
*                Zero values are ignored, except that an all zero
*                vector denotes a continuous line.
* I <-> K      - Element of the array IPATTN being accessed.  This
*                value is updated.
* R <-> REMAIN - Real value specifying what portion of IPATTN(K)
*                remains to be used.  This value is updated.  The
*                combination of K and REMAIN allow this routine to be
*                used in a loop to draw several line segments with the
*                pattern continuous between line segments.  Suitable
*                values for the first call to this routine are K=1,
*                REMAIN=ABS(IPATTN(K)).
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:29:05 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE XYDASH (IX1,IY1, IX2,IY2, IPATTN, K, REMAIN)


      INTEGER IX1,IY1,IX2,IY2,K
      INTEGER IPATTN(5)
      INTEGER IDX,IDY,IXS,IYS,I,IXF,IYF

      REAL REMAIN
      REAL VECTL,VECTD


      IDX=IX2-IX1
      IDY=IY2-IY1
      IXS=IX1
      IYS=IY1

* VECTL is the length of the full line to be drawn
* VECTD is the length of the line that will be drawn if
*   the present pattern element is used fully.
      VECTL=SQRT(REAL(IDX)**2+REAL(IDY)**2)
      VECTD=REMAIN

 100  CONTINUE

      IF (REMAIN.LE.0.0) THEN

* New pattern element.  If IPATTN is all zero, draw
* the whole vector.
        DO 120 I=1,5
          K=MOD(K,5)+1
          IF (IPATTN(K).NE.0) THEN
            REMAIN=ABS(IPATTN(K))
            VECTD=VECTD+REMAIN
            GO TO 140
          END IF
 120    CONTINUE
        VECTD=VECTL
 140    CONTINUE

      END IF


      IF (VECTD.LT.VECTL) THEN

* Partial vector
* Note: The algorithm employed, resolves the end points of the line
*       segment onto the plotting grid.  This is done in the same
*       manner as in the drawing routine so that the end points of
*       the line segment have the same plotting coordinates as the
*       corresponding points on the full line.
        IF (ABS(IDX).GE.ABS(IDY)) THEN
          IF (IDX.NE.0) THEN
            IXF=NINT((VECTD/VECTL)*IDX) + IX1
            IYF=NINT((REAL(IXF-IX1)/IDX) * IDY) + IY1
          ELSE
            IXF=IX1
            IYF=IY1
          END IF
        ELSE
          IYF=NINT((VECTD/VECTL)*IDY) + IY1
          IXF=NINT((REAL(IYF-IY1)/IDY) * IDX) + IX1
        END IF
        REMAIN=0.0

      ELSE

* Vector to the end of the line segment
        IXF=IX2
        IYF=IY2
        REMAIN=VECTD-VECTL

      END IF

* Draw a line segment
      IF (IPATTN(K).GE.0)
     -  CALL XYVECT(IXS,IYS,IXF,IYF)
      IXS=IXF
      IYS=IYF

* See if the whole vector has been drawn
      IF (VECTD.LT.VECTL) GO TO 100


      RETURN

      END
