*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE SETPLW (IWIDTH)
*     SUBROUTINE GETPLW (IWIDTH)
*
*
* Purpose:
*     Set the line width for a plot
*     Get the line width for a plot
*
*
* Description:
*     This routine sets or determines the line width for subsequent
*     plotting.  For some devices, a negative line width has the effect
*     of erasing or writing with the background colour or intensity.
*     In that case, the line width is determined from the magnitude of
*     the specified line width parameter.
*
*
* Parameters:
*     Subroutine SETPLW
* I ->  IWIDTH - Line width in plotting units
*
*     Subroutine GETPLW
* I <-  IWIDTH - Line width in plotting units
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:28:56 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE SETPLW (IWIDTH)


      INTEGER IWIDTH
      INTEGER LWIDTH

      SAVE LWIDTH
      DATA LWIDTH/6/


* Set the line width
      LWIDTH=IWIDTH

      GO TO 900

*----------
* Return the current line width
      ENTRY GETPLW (IWIDTH)


      IWIDTH=LWIDTH


 900  RETURN

      END
