*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE SETGRS (IX, IY, LENX, LENY)
*     SUBROUTINE GETGRS (IX, IY, LENX, LENY)
*
*
* Purpose:
*     Set the graph size for a plot
*     Get the graph size for a plot
*
*
* Description:
*     This subroutine sets or determines the rectangular area to be
*     used for plotting graphs.  Normally data values that result in
*     values outside the rectangle will be clipped.
*
*
* Parameters:
*     Subroutine SETGRS
* I ->  IX     - X coordinate of the lower lefthand corner of the graph
*                rectangle
* I ->  IY     - Y coordinate of the lower lefthand corner of the graph
*                rectangle
* I ->  LENX   - Size of the graph rectangle, X coordinate
* I ->  LENY   - Size of the graph rectangle, Y coordinate
*
*     Subroutine GETGRS
* I <-  IX     - X coordinate of the lower lefthand corner of the graph
*                rectangle
* I <-  IY     - Y coordinate of the lower lefthand corner of the graph
*                rectangle
* I <-  LENX   - Size of the graph rectangle, X coordinate
* I <-  LENY   - Size of the graph rectangle, Y coordinate
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:28:53 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE SETGRS (IX, IY, LENX, LENY)


      INTEGER IX,IY,LENX,LENY
      INTEGER IXS,IYS,LENXS,LENYS

      SAVE IXS,IYS,LENXS,LENYS

      DATA IXS,IYS,LENXS,LENYS/720,440,3240,2400/


* Set the graph rectangle
      IXS=IX
      IYS=IY
      LENXS=LENX
      LENYS=LENY

      GO TO 900

*----------
* Return the current graph size
      ENTRY GETGRS (IX, IY, LENX, LENY)


* Return the size of the graph rectangle
      IX=IXS
      IY=IYS
      LENX=LENXS
      LENY=LENYS


 900  RETURN

      END
