*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE SETCHR (IWDTH, IHGHT, ANGLE)
*     SUBROUTINE GETCHR (IWDTH, IHGHT, ANGLE)
*
*
* Purpose:
*     Set the character size and orientation for a plot
*     Get the character size and orientation for a plot
*
*
* Description:
*     The character size is specified by a width and height.  The
*     character orientation is specified by a plotting angle.
*     Characters are defined on discrete grid.  Characters are
*     defined on a 10 by 14 point grid.  Characters are drawn by
*     joining points on the grid.  The example below shows an
*     uppercase "E" which extends to the edge of the grid and a
*     lowercase "o" which occupies only a portion of the grid.
*
*                      width       width
*                    |-------|   |-------|
*
*            -       o-------o   .........
*            |       |.......    .........
*            |       |........   .........
*            |       |.......    .........
*            |       |........   ..o---o..
*            |       |........   ./.....\.
*          height    o-------o   o.......o
*            |       |........   |.......|
*            |       |........   |.......|
*            |       |........   |.......|
*            |       |........   o.......o
*            |       |........   .\...../.
*            -       o-------o   ..o---o..
*
*
* Parameters:
*     Subroutine SETCHR
* I ->  IWDTH  - Width of the characters in plotting units (full scale
*                is 4096)
* I ->  IHGHT  - Height of the characters in plotting units (full scale
*                is 4096)
* R ->  ANGLE  - Plotting angle for the characters relative to the
*                horizontal (in degrees)
*
*     Subroutine GETCHR
* I <-  IWDTH  - Width of the characters in plotting units (full scale
*                is 4096)
* I <-  IHGHT  - Height of the characters in plotting units (full scale
*                is 4096)
* R <-  ANGLE  - Plotting angle for the characters relative to the
*                horizontal (in degrees)
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:28:50 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE SETCHR (IWDTH, IHGHT, ANGLE)


      INTEGER IWDTH,IHGHT
      INTEGER LWDTH,LHGHT

      REAL ANGLE
      REAL CANGLE

      SAVE LWDTH,LHGHT,CANGLE

      DATA LWDTH,LHGHT,CANGLE/32,48,0.0/


* Set the character widths
      LWDTH=IWDTH
      LHGHT=IHGHT
      CANGLE=ANGLE

      GO TO 900

*----------
* Return the current character dimensions
      ENTRY GETCHR (IWDTH, IHGHT, ANGLE)


      IWDTH=LWDTH
      IHGHT=LHGHT
      ANGLE=CANGLE


 900  RETURN

      END
