*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE PLVCPX (SYMBOL, X, F, NPT, DATREG)
*
*
* Purpose:
*     Plot points as plot symbols
*
*
* Description:
*     The real valued data is plotted by plotting characters at the
*     position corresponding to the data values.  Both the function
*     values and the abscissa values are specified by an array of
*     data.  This routine attempts to centre the characters at the
*     data positions.  To this end, lower case letters are offset
*     differently than upper case letters and special symbols.  The
*     plotting area can be set by calling SETGRS.  If a data point
*     falls outside of the plotting area, the corresponding character
*     is not plotted.
*
*
* Parameters:
* C ->  SYMBOL - Character variable specifying the character to be
*                plotted.  The character size must be set to the
*                desired size before calling this routine.
* R ->  X      - Array of abscissa data
* R ->  F      - Array of function values
* I ->  NPT    - Number of data points in the arrays X and F
* R ->  DATREG - Data limits.  The four elements of DATREG define the
*                plot region.
*                DATREG(1,1) - Lower limit for the X data
*                DATREG(2,1) - Lower limit for the function values
*                DATREG(1,2) - Upper limit for the X data
*                DATREG(2,2) - Upper limit for the function values
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:28:44 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE PLVCPX (SYMBOL, X, F, NPT, DATREG)


      INTEGER NPT
      INTEGER IXORIG,IYORIG,LENX,LENY
      INTEGER I,IX1,IY1,IX,IY

      REAL X(*),F(*),DATREG(2,2)
      REAL PVX,PVY

      CHARACTER*1 SYMBOL


* Plot by placing characters at the points
      CALL GETGRS(IXORIG,IYORIG,LENX,LENY)
      PVX=LENX/(DATREG(1,2)-DATREG(1,1))
      PVY=LENY/(DATREG(2,2)-DATREG(2,1))
      IX1=IXORIG+LENX
      IY1=IYORIG+LENY
      DO 100 I=1,NPT
        IX=NINT((X(I)-DATREG(1,1))*PVX) + IXORIG
        IY=NINT((F(I)-DATREG(2,1))*PVY) + IYORIG
        IF (IX.GE.IXORIG .AND. IX.LE.IX1 .AND.
     -      IY.GE.IYORIG .AND. IY.LE.IY1)
     -   CALL CENSYM(IX,IY,SYMBOL)
 100  CONTINUE


      RETURN

      END
