*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE PLVCFX (X, F, NPT, DATREG, IPATTN)
*
*
* Purpose:
*     Plot a tabulated function
*
*
* Description:
*     The real valued data is plotted by joining the data points with
*     straight line segments.  Both the function values and the
*     abscissa values are specified by an array of data. The plotting
*     area can set by calling SETGRS.  Plotting vectors outside of the
*     plotting area are clipped.
*
*
* Parameters:
* R ->  X      - Array of abscissa data
* R ->  F      - Array of function values
* I ->  NPT    - Number of data points in the arrays X and F
* R ->  DATREG - Data limits.  The four elements of DATREG define the
*                plot region.
*                DATREG(1,1) - Lower limit for the X data
*                DATREG(2,1) - Lower limit for the function values
*                DATREG(1,2) - Upper limit for the X data
*                DATREG(2,2) - Upper limit for the function values
* I ->  IPATTN - Line pattern.  This is a five element array describing
*                the line pattern to be used. The patterns are coded as
*                lengths of on and off segments.  A positive value
*                indicates on, while a negative value indicates off.
*                Zero values are ignored, except that an all zero
*                vector denotes a continuous line.
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.5 $  $Date: 1995/03/08 15:28:38 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE PLVCFX (X, F, NPT, DATREG, IPATTN)


      INTEGER NPT
      INTEGER IDX,IDY
      INTEGER K,IXS,IYS,I,IXF,IYF,IXSC,IYSC,IXFC,IYFC,IVISIB
      INTEGER IXORIG,IYORIG,LENX,LENY
      INTEGER IPATTN(5)

      REAL X(*),F(*),DATREG(2,2)
      REAL PVX,PVY
      REAL VLEN
      REAL PATLEN,REMAIN,VLCLIP


* Statement function to calculate the length of vector
      VLEN(IDX,IDY) = SQRT(REAL(IDX)**2+REAL(IDY)**2)


      IF (NPT.LE.0) RETURN

* Determine the pattern size
      PATLEN=0.0
      DO 100 K=1,5
        PATLEN=PATLEN+ABS(IPATTN(K))
 100  CONTINUE
      REMAIN=ABS(IPATTN(1))
      K=1

* Get the starting point coordinates
      CALL GETGRS(IXORIG,IYORIG,LENX,LENY)
      PVX=LENX/(DATREG(1,2)-DATREG(1,1))
      PVY=LENY/(DATREG(2,2)-DATREG(2,1))

      IXS=NINT((X(1)-DATREG(1,1))*PVX) + IXORIG
      IYS=NINT((F(1)-DATREG(2,1))*PVY) + IYORIG

* Plot by joining the data points with straight lines
      DO 400 I=MIN(NPT,2),NPT
        IXF=NINT((X(I)-DATREG(1,1))*PVX) + IXORIG
        IYF=NINT((F(I)-DATREG(2,1))*PVY) + IYORIG

* Clip the vector
        CALL DECOUP(IXORIG,IYORIG,IXORIG+LENX,IYORIG+LENY,
     -              IXS,IYS, IXF,IYF,
     -              IXSC,IYSC, IXFC,IYFC, IVISIB)

* Account for clipping of the start of the vector
        IF (PATLEN.GT.0.0) THEN
          VLCLIP=VLEN(IXS-IXSC,IYS-IYSC)
          REMAIN=REMAIN-AMOD(VLCLIP,PATLEN)
 220      IF (REMAIN.LT.0.0) THEN
            K=MOD(K,5)+1
            REMAIN=REMAIN+ABS(IPATTN(K))
          GO TO 220
          END IF
        END IF

* Plot the clipped vector
        IF (IVISIB.GT.0)
     -    CALL XYDASH(IXSC,IYSC, IXFC,IYFC, IPATTN, K, REMAIN)

* Account for clipping of the end of the vector
        IF (PATLEN.GT.0.0) THEN
          VLCLIP=VLEN(IXF-IXFC,IYF-IYFC)
          REMAIN=REMAIN-AMOD(VLCLIP,PATLEN)
 240      IF (REMAIN.LT.0.0) THEN
            K=MOD(K,5)+1
            REMAIN=REMAIN+ABS(IPATTN(K))
          GO TO 240
          END IF
        END IF

* Update the beginning of the next vector
        IXS=IXF
        IYS=IYF

 400  CONTINUE


      RETURN

      END
