*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE PLTLEG (TITLE)
*
*
* Purpose:
*     Plot a legend string
*
*
* Description:
*     This subroutine is intended to provide an easy way to print a
*     legend at the top of a standard graph drawn using one of the high
*     level plotting routines (e.g. PLOTYX or PLOTYI).  An example of a
*     call to this routine is as follows.
*
*       CALL PLTLEG('Test data from Jan. 31')
*
*
* Parameters:
* C ->  TITLE  - Character string containing the string to be plotted.
*                For the default graph size, there is enough room for
*                67 characters at the default width to be plotted
*                across the top of the graph.
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:28:32 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE PLTLEG (TITLE)


      INTEGER IW,IH
      INTEGER IXORIG,IYORIG,LENX,LENY

      REAL ANG
      CHARACTER*(*) TITLE


* Save the character plotting angle
      CALL GETCHR(IW,IH,ANG)
      CALL GETGRS(IXORIG,IYORIG,LENX,LENY)

* Plot the title
      CALL PLTEXT(IXORIG,IYORIG+LENY+NINT(3.333333333*IH),0,TITLE)

* Restore the character plotting angle
      CALL SETCHR(IW,IH,ANG)


      RETURN

      END
