*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE PLTITL (XLABEL, XUNITS, YLABEL, YUNITS)
*
*
* Purpose:
*     Plot a titles on a graph
*
*
* Description:
*     This subroutine is intended to provide an easy way to label the
*     axes for a standard graph drawn using one of the high level
*     plotting routines (e.g. PLOTYX or PLOTYI).  An example of a call
*     to this routine is as follows.
*
*       CALL PLTITL('Input','Volts','Output','mA')
*
*     This routine should be called AFTER the call to the plotting
*     routines if a non-standard position or size is specified in the
*     plotting routines.  The character size used is double the current
*     character size.
*
*
* Parameters:
* C ->  XLABEL - Character string containing the title for the X axis.
*                If XUNITS is null, this label is centered below the
*                axis.  Otherwise it is offset to allow room for the
*                units label.
* C ->  XUNITS - Character string containing the units for the X axis.
*                This label is placed to the right of the position
*                reserved for a power of ten multiplier on a labelled
*                axis.
* C ->  YLABEL - Character string containing the title for the Y axis.
*                If YUNITS is null, this label is centered below the
*                axis.  Otherwise it is offset to allow room for the
*                units label.
* C ->  YUNITS - Character string containing the units for the Y axis.
*                This label is placed above the position reserved for
*                a power of ten multiplier on a labelled axis.
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:28:29 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE PLTITL (XLABEL, XUNITS, YLABEL, YUNITS)


      INTEGER IW,IH,IWN,IHN,LC,IX,IY
      INTEGER IXORIG,IYORIG,LENX,LENY

      REAL ANG

      CHARACTER*(*) XLABEL,XUNITS,YLABEL,YUNITS


* Get the character size and the graph position
      CALL GETCHR(IW,IH,ANG)
      CALL GETGRS(IXORIG,IYORIG,LENX,LENY)

* Notes:
* - At the double character size, 5 character positions are
*   allowed for in the units label
*   (the space required is 7*IW).
* - A space (double character size) takes up 1.5*IW.
* - The power of ten multiplier (for a three character exponent
*   (e.g. "-12") is of length 4.3125*IW.
* - The total space taken up (sum of above) is 12.8125*IW.
* - The remaining space is used to center the main label.

* Plot the X axis labels
      IWN=2*IW
      IHN=2*IH
      CALL SETCHR(IWN,IHN,0.0)
      IF (LEN(XUNITS).GT.0) THEN
        LC=NINT(12.8125*IWN)
      ELSE
        LC=0
      END IF
      IX=IXORIG+(LENX-LC)/2
      IY=IYORIG-NINT(2.333333333*IHN)
      CALL PLTEXT(IX,IY,5,XLABEL)

      IX=IXORIG+LENX-NINT(7.*IWN)
      CALL PLTEXT(IX,IY,2,XUNITS)

* Plot the Y axis labels
      CALL SETCHR(IWN,IHN,90.)
      IF (LEN(YUNITS).GT.0) THEN
        LC=NINT(12.8125*IWN)
      ELSE
        LC=0
      END IF
      IX=IXORIG-NINT(3.333333333*IHN)
      IY=IYORIG+(LENY-LC)/2
      CALL PLTEXT(IX,IY,3,YLABEL)

      IY=IYORIG+LENY-NINT(7.*IWN)
      CALL PLTEXT(IX,IY,0,YUNITS)

* Restore the character sizes
      CALL SETCHR(IW,IH,ANG)


      RETURN

      END
