*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE PLTEXT (IX, IY, ICENT, STRING)
*
*
* Purpose:
*     Plot a character string
*
*
* Description:
*     This routine plots a text string at the given plotting
*     coordinates.  The standard character spacing is 1.5 times the
*     character width.  The character size and the plotting angle must
*     be selected beforehand with a call to subroutine SETCHR.
*
*     This routine checks for the presence of special control
*     characters in the text string.
*                         Control  ASCII
*        Character         Key     Code     Function
*      NUL (null)         CTRL-@     0   null character
*      LF (line feed)     CTRL-J,   10   start a new line
*      VT (vertical tab)  CTRL-K,   11   start small characters
*      SO (shift out)     CTRL-N,   14   end superscript, subscript
*                                        or small characters
*      SI (shift in)      CTRL-O,   15   start superscripts
*      SUB (substitute)   CTRL-Z,   26   start subscripts
*
*     The NUL character (ASCII 0) is treated as a zero width character
*     of normal height.  The line feed character NL marks the end of a
*     line of characters.  Lines of characters are stacked vertically
*     (from top to bottom), a fixed distance apart (1.5 times the
*     standard character height), with each line of text left
*     justified.
*
*     The VT control character turns on small character mode.  These
*     characters are of reduced size.   The SO character or the LF
*     character terminates small character mode.  The SI character
*     starts superscript mode.  Superscript characters are raised
*     above the baseline and are plotted at a reduced size.  The SUB
*     character starts subscript mode.  Subscript characters are
*     lowered below the baseline and are plotted at a reduced size.
*     Both superscripts and subscripts are turned off with SO or LF
*     control characters.
* 
*
*
* Parameters:
* I ->  IX     - X coordinate of the reference point for the
*                character string (plotting units)
* I ->  IY     - Y coordinate of the reference point for the
*                character string (plotting units)
* I ->  ICENT  - Centering option specifying the location of the
*                reference point for the plotted text.  The plotted
*                text which may consist of several individual lines of
*                text can be considered to be contained in a box.
*                ICENT specifies the position of the reference point
*                in that box as shown in the table below.  The
*                designations (left, centre, right and top, centre,
*                bottom) refer to positions of the box containing the
*                string before the string is rotated to the desired
*                plotting angle.
*                          Left     Centre    Right
*                    Top     2---------5---------8
*                    Centre  1         4         7
*                    Bottom  0---------3---------6
* C ->  STRING - Character string to be plotted.  This string may
*                include control characters to turn on and turn off
*                superscript or subscript characters and split text
*                into lines.
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.5 $  $Date: 1995/03/08 15:28:26 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE PLTEXT (IX, IY, ICENT, STRING)


      INTEGER ICNWL,ICSML,ICSUP,ICSUB,ICNOR
      PARAMETER (ICNWL=10,ICSML=11,ICSUP=15,ICSUB=26,ICNOR=14)

* Character spacing and size parameterization

* CHNOR  - height of a normal character
* CHSML  - height of a small character
* CRSUP  - vertical offset for superscript characters
* CRSUB  - vertical offset for subscript characters
* CWNOR  - width of a normal character
* CWSML  - width of a small character
* CSPNN  - spacing inserted between normal characters
* CSPSS  - spacing inserted between small characters
* CSPNS  - spacing inserted between a normal and a small character
* CSPSN  - spacing inserted between a small and a normal character
* CBLSP  - baseline skip between lines of text
      REAL CHNOR,CHSML,CRSUP,CRSUB,CWNOR,CWSML,
     -     CSPNN,CSPSS,CSPNS,CSPSN,CBLSP
      PARAMETER (CHNOR=1.0,CHSML=0.75*CHNOR,
     -           CWNOR=1.0,CWSML=0.75*CWNOR,
     -           CRSUP=0.5,CRSUB=-0.25,
     -           CSPNN=0.5,CSPSS=(CWSML/CWNOR)*CSPNN,
     -           CSPNS=0.5*(CSPNN+CSPSS),CSPSN=CSPNS,
     -           CBLSP=1.5*CHNOR)

      INTEGER IX,IY,ICENT
      INTEGER IW,IH,ICENTW,ICENTH,IXR,IYR,IXC,IYC,ISIZ,IPRS,I,NL

      CHARACTER*(*) STRING

      REAL WB,HB,W,H,ANG,X,Y

      REAL CSPACE(0:1,-1:1)
      REAL CWIDTH(0:1)
      DATA CSPACE/0.0,0.0,CSPNN,CSPNS,CSPSN,CSPSS/
      DATA CWIDTH/CWNOR,CWSML/


* Get the character size and orientation
      CALL GETCHR(IW,IH,ANG)

* Find the size of the text box
      CALL WHTEXT(STRING,WB,HB)

* Determine the number of lines of text
      NL=1
      DO 100 I=1,LEN(STRING)
        IF (STRING(I:I).EQ.CHAR(ICNWL)) NL=NL+1
 100  CONTINUE

* Width centering
      ICENTW=ICENT/3
      IF (ICENTW.EQ.0) THEN
        W=0.0
      ELSE IF (ICENTW.EQ.1) THEN
        W=0.5*WB
      ELSE
        W=WB
      END IF

* Height centering
      ICENTH=MOD(ICENT,3)
      IF (ICENTH.EQ.0) THEN
        H=0.0
      ELSE IF (ICENTH.EQ.1) THEN
        H=0.5*HB
      ELSE
        H=HB
      END IF

* Calculate the rotated offset
      CALL ROTPTC(W,H,ANG,IXR,IYR)
      IXC=IX-IXR
      IYC=IY-IYR

* Plot the characters one at a time
      ISIZ=0
      IPRS=-1
      X=0.0
      Y=0.0
      DO 200 I=1,LEN(STRING)
        IF (STRING(I:I).EQ.CHAR(ICSML)) THEN
          ISIZ=1
          CALL SETCHR(NINT(CWSML*IW),NINT(CHSML*IH),ANG)
          Y=0.0
        ELSE IF (STRING(I:I).EQ.CHAR(ICSUP)) THEN
          ISIZ=1
          CALL SETCHR(NINT(CWSML*IW),NINT(CHSML*IH),ANG)
          Y=CRSUP
        ELSE IF (STRING(I:I).EQ.CHAR(ICSUB)) THEN
          ISIZ=1
          CALL SETCHR(NINT(CWSML*IW),NINT(CHSML*IH),ANG)
          Y=CRSUB
        ELSE IF (STRING(I:I).EQ.CHAR(ICNOR)) THEN
          ISIZ=0
          CALL SETCHR(IW,IH,ANG)
          Y=0.0
        ELSE IF (STRING(I:I).EQ.CHAR(ICNWL)) THEN
          ISIZ=0
          CALL SETCHR(IW,IH,ANG)
          Y=0.0
          X=0.0
          IPRS=-1
          NL=NL-1
        ELSE
          IF (STRING(I:I).NE.CHAR(0)) THEN
            X=X+CSPACE(ISIZ,IPRS)
            CALL ROTPTC(X*IW,(Y+(NL-1)*CBLSP)*IH,ANG,IXR,IYR)
            CALL PLCHAR(IXC+IXR,IYC+IYR,STRING(I:I))
            X=X+CWIDTH(ISIZ)
          END IF
          IPRS=ISIZ
        END IF
 200  CONTINUE

* Restore the character size
      CALL SETCHR(IW,IH,ANG)


      RETURN

      END
