*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE PLINIT (DEVICE, OPTION)
*
*
* Purpose:
*     Initialize a plot
*
*
* Description:
*     This subroutine initializes the given plotting device.  PLINIT
*     may be called several times for different devices.  In addition
*     PLINIT may be called in the middle of a plot to change the
*     options associated with a device.  Subroutine PLEND should be
*     called to terminate plotting.
*
*     The display surface is discretized into a grid which is nominally
*     4096 by 4096 units (0 to 4095 in each of the X and Y directions).
*     Before plotting, the pen position is at (0,0).
*
*
* Parameters:
* C ->  DEVICE - Character string specifying the plotting device.  This
*                name is subject to case conversion.
*             LW or PS - Postscript file.
*                  This routine initializes the Postscript plot.  It
*                  writes a Postscript header to the plot file.  The
*                  mapping is set to give 600 plotting units per inch
*                  and an X offset of 0.5 inches and a Y offset of
*                  2 inches.  For device LW, the Postscript file is
*                  queued for printing on a Postscript printer and
*                  subsequently deleted.
*             TK - Tektronix display terminal.
*                  This routine leaves the Tektronix terminal in
*                  graphics mode.  Any other I/O to the Tektronix
*                  terminal should be avoided while plotting is in
*                  progress.  A call to PLEND at the end of plotting
*                  will reset the Tektronix terminal to alpha-numeric
*                  mode.  The Tektronix terminal has a resolution of
*                  1024 points horizontally and 780 points vertically.
*                  These are mapped such that the full plotting range
*                  (0 to 4095) is visible horizontally while
*                  vertically only points in the range 0 to 3120 are
*                  visible.
*             UN - Standard Unix plot file.
*                  This routine initializes the plot file.  The plot
*                  area is defined to be in the area from (0,0) to
*                  (4095,4095).
*             VT - ReGIS terminal.
*                  This routine sets the terminal to ReGIS graphics
*                  mode.  Any other I/O to the terminal should be
*                  avoided while plotting is in progress.  A call to
*                  PLEND at the end of plotting will exit ReGIS mode.
*                  The terminal has a resolution of 800 points
*                  horizontally and 480 points vertically.  These are
*                  mapped such that the full plotting range (0 to 4095)
*                  is visible horizontally (valid range is -512 to
*                  4607) while vertically, the valid ordinate range is
*                  0 to 3071.  Coordinates outside this range are
*                  clipped.
* C ->  OPTION - Character string specifying the options.  Options are
*                separated by commas and/or whitespace (blanks, tabs,
*                or nulls).  If any option is omitted, the default
*                value is used.  An all blank string gives the default
*                values.  The same keyword may appear more than once,
*                with the last instance taking precedence.  The
*                available options are specific to the particular
*                device being selected.  Device options generally
*                remain in effect unless explicitly overridden by
*                another call to PLINIT.  However, the CLEAR and
*                OVERLAY options apply only to one invokation of
*                PLINIT.
*          for DEVICE=LW or PS
*                FILENAME=name - Specifies the name of the file to
*                  which plot data is sent.  The file name is not used
*                  if this plot device is already active.  The special
*                  file name "*" can be  used to direct output to the
*                  standard output (Fortran unit 6).  The default file
*                  name for files which are not sent to the printer
*                  is derived from the name of the image (xxx.epsf
*                  where xxx is the image name).  For files sent
*                  for printing, a unique temporary file name is
*                  created.
*                PRINT or NOPRINT - Specifies whether the Postscript
*                  file is to be queued for printing.  The default is
*                  PRINT for device LW and NOPRINT for device PS.
*          for DEVICE=TK
*                CLEAR - The screen is erased.  CLEAR is the default
*                  option if this plot device is not active.
*                OVERLAY - The screen is not erased.  OVERLAY is the
*                  default option if this plot device is already
*                 active.
*                FILENAME=name - Specifies the name of the file or
*                  terminal to which plot data is sent.  The file name
*                  is not used if this plot device is already active.
*                  The special file name "*" can be  used to direct
*                  output to the standard output (Fortran unit 6).  The
*                  default file name is "/dev/tty".
*         for DEVICE=UN
*                FILENAME=name - Specifies the name of the file to
*                  which plot data is sent.  The file name is not used
*                  if this plot device is already active.  The special
*                  file name "*" can be  used to direct output to the
*                  standard output (Fortran unit 6).  The default file
*                  name is "unplot.dat".
*          for DEVICE=VT
*                CLEAR - The screen is erased.  CLEAR is the default
*                  option if this plot device is not active.
*                OVERLAY - The screen is not erased.  OVERLAY is the
*                  default option if this plot device is already
*                  active.
*                FILENAME=name - Specifies the name of the file or
*                  terminal to which plot data is sent.  The file name
*                  is not used if this plot device is already active.
*                  The special file name "*" can be  used to direct
*                  output to the standard output (Fortran unit 6).
*                  The default file name is "/dev/tty".
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.5 $  $Date: 1995/03/08 15:28:15 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE PLINIT (DEVICE, OPTION)


      INTEGER NC
      INTEGER IX0,IY0
      INTEGER LENSTR

      CHARACTER*(*) DEVICE,OPTION
      CHARACTER*80 TNAME
      CHARACTER*256 SOPT

* Plot device flags common area
      LOGICAL PS,TK,UN,VT
      COMMON /DEVCOM/ PS,TK,UN,VT


* Reset the pen position at the beginning of a plot
* Initialize the line width, graph size and character size
      IF (.NOT.(PS .OR. TK .OR. UN .OR. VT)) THEN
        CALL SETPOS(0,0)
        CALL SETPLW(6)
        CALL SETCHR(32,48,0.0)
        CALL SETGRS(720,440,3240,2400)
      END IF


* Search for a match to the device
      TNAME=DEVICE
      CALL UPCASE(TNAME,TNAME)
      CALL STTRIM(OPTION,SOPT,NC)

      IF (TNAME.EQ.'LW') THEN
        CALL PSINIT('PRINT '//SOPT(1:NC))
        PS=.TRUE.

      ELSE IF (TNAME.EQ.'PS') THEN
        CALL PSINIT(SOPT(1:NC))
        PS=.TRUE.

      ELSE IF (TNAME.EQ.'TK') THEN
        CALL TKINIT(SOPT(1:NC))
        TK=.TRUE.

      ELSE IF (TNAME.EQ.'UN') THEN
        CALL UNINIT(SOPT(1:NC))
        UN=.TRUE.

      ELSE IF (TNAME.EQ.'VT') THEN
        CALL VTINIT(SOPT(1:NC))
        VT=.TRUE.

      ELSE
        NC=LENSTR(TNAME)
        CALL HALT('PLINIT - invalid plotting device: '//TNAME(1:NC))

      END IF

* Update the plot position
      CALL GETPOS(IX0,IY0)
      CALL XYMOVE(IX0,IY0)


      RETURN

      END
