*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE WHTEXT (STRING, W, H)
*
*
* Purpose:
*     Find the plot width and height of a text string
*
*
* Description:
*     This routine determines the width and height of a box containing
*     a given text string.  The widths and heights of the individual
*     letters are set by calling routine SETCHR.
*
*     This routine checks for the presence of special control
*     characters in the text string.
*                         Control  ASCII
*        Character         Key     Code     Function
*      NUL (null)         CTRL-@     0   null character
*      LF (line feed)     CTRL-J,   10   start a new line
*      VT (vertical tab)  CTRL-K,   11   start small characters
*      SO (shift out)     CTRL-N,   14   end superscript, subscript
*                                        or small characters
*      SI (shift in)      CTRL-O,   15   start superscripts
*      SUB (substitute)   CTRL-Z,   26   start subscripts
*
*     The NUL character (ASCII 0) is treated as a zero width character
*     of normal height.  The line feed character NL marks the end of a
*     line of characters.  Lines of characters are stacked vertically
*     (from top to bottom), a fixed distance apart stacked vertically
*     (from top to bottom), a fixed distance apart (1.5 times the
*     standard character height), with each line of text left
*     justified.
*
*     The VT control character turns on small character mode.  These
*     characters are of reduced size.   The SO character or the LF
*     character terminates small character mode.  The SI character
*     starts superscript mode.  Superscript characters are raised
*     above the baseline and are plotted at a reduced size.  The SUB
*     character starts subscript mode.  Subscript characters are
*     lowered below the baseline and are plotted at a reduced size.
*     Both superscripts and subscripts are turned off with SO or LF
*     control characters.
*
*     Each character in the text string is assigned a height, width
*     and depth.  Heights and depths are measured with respect to the
*     baseline of the character.  The depth of a character is ignored
*     in computing the size of the text box.  For each line of text,
*     the characters are stacked side by side with extra space inserted
*     between characters.  The  size of the text box for a line is
*     determined by the maximum height of any character in the line and
*     sum of the widths of the characters and spacing in the line.
*     Lines of text are stacked a fixed distance apart.  The height of
*     the overall box is determined from the height of the top line,
*     plus the interline spacing for each of the remaining lines of
*     text.  The width of the overall box is the maximum of the widths
*     of the text lines.
*
*
* Parameters:
* C ->  STRING - Character string to be plotted.  This string may
*                include control characters to turn on and turn off
*                superscript or subscript characters and split text
*                into lines.
* R <-  W      - Width of the text in plotting units
* R <-  H      - Height of the text in plotting units
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.5 $  $Date: 1995/03/08 15:31:02 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE WHTEXT (STRING, W, H)


      INTEGER ICNWL,ICSML,ICSUP,ICSUB,ICNOR
      PARAMETER (ICNWL=10,ICSML=11,ICSUP=15,ICSUB=26,ICNOR=14)

* Character spacing and size parameterization

* CHNOR  - height of a normal character
* CHSML  - height of a small character
* CRSUP  - vertical offset for superscript characters
* CRSUB  - vertical offset for subscript characters
* CWNOR  - width of a normal character
* CWSML  - width of a small character
* CSPNN  - spacing inserted between normal characters
* CSPSS  - spacing inserted between small characters
* CSPNS  - spacing inserted between a normal and a small character
* CSPSN  - spacing inserted between a small and a normal character
* CBLSP  - baseline skip between lines of text
      REAL CHNOR,CHSML,CRSUP,CRSUB,CWNOR,CWSML,
     -     CSPNN,CSPSS,CSPNS,CSPSN,CBLSP
      PARAMETER (CHNOR=1.0,CHSML=0.75*CHNOR,
     -           CWNOR=1.0,CWSML=0.75*CWNOR,
     -           CRSUP=0.5,CRSUB=-0.25,
     -           CSPNN=0.5,CSPSS=(CWSML/CWNOR)*CSPNN,
     -           CSPNS=0.5*(CSPNN+CSPSS),CSPSN=CSPNS,
     -           CBLSP=1.5*CHNOR)

      INTEGER ISIZ,IPRS,I,IW,IH

      CHARACTER*(*) STRING

      REAL W,H
      REAL WL,HL,WT,HT,HH,ANG

      REAL CSPACE(0:1,-1:1)
      REAL CWIDTH(0:1)
      DATA CSPACE/0.0,0.0,CSPNN,CSPNS,CSPSN,CSPSS/
      DATA CWIDTH/CWNOR,CWSML/


* Accumulate normalized widths and find the maximum height
      ISIZ=0
      IPRS=-1
      HL=0.0
      WL=0.0
      HT=0.0
      WT=0.0
      HH=CHNOR
      DO 100 I=1,LEN(STRING)
        IF (STRING(I:I).EQ.CHAR(ICSML)) THEN
          ISIZ=1
          HH=CHSML
        ELSE IF (STRING(I:I).EQ.CHAR(ICSUP)) THEN
          ISIZ=1
          HH=CRSUP+CHSML
        ELSE IF (STRING(I:I).EQ.CHAR(ICSUB)) THEN
          ISIZ=1
          HH=CRSUB+CHSML
        ELSE IF (STRING(I:I).EQ.CHAR(ICNOR)) THEN
          ISIZ=0
          HH=CHNOR
        ELSE IF (STRING(I:I).EQ.CHAR(ICNWL)) THEN
          WT=MAX(WT,WL)
          HT=HT+HL
          ISIZ=0
          HH=CHNOR
          IPRS=-1
          HL=CBLSP
          WL=0.0
        ELSE
          HL=MAX(HL,HH)
          IF (STRING(I:I).NE.CHAR(0))
     -      WL=WL + CSPACE(ISIZ,IPRS)+CWIDTH(ISIZ)
          IPRS=ISIZ
        END IF
 100  CONTINUE

* Implicit end of line
      WT=MAX(WT,WL)
      HT=HT+HL

* Get the character size to denormalize the size
      CALL GETCHR(IW,IH,ANG)
      W=WT*IW
      H=HT*IH


      RETURN

      END
