*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE SFPW10 (IX0, IY0, ICENT, IEXP)
*
*
* Purpose:
*     Plot a power of 10 scale factor
*
*
* Description:
*     This subroutine prints a scale factor of the form 10**IEXP at a
*     given location on a plot.  The scale factor is printed at the
*     current character plotting angle.  This routine also uses the
*     character size in effect to determine the character sizew.
*
*
* Parameters:
* I ->  IX0    - X coordinate of the lower right hand corner of the
*                scale factor
* I ->  IY0    - Y coordinate of the lower right hand corner of the
*                scale factor
* I ->  ICENT  - Centering option specifying the location of reference
*                point for the plotted text.  The plotted text can be
*                considered to be contained in a box.  ICENT specifies
*                the position of the reference point in that box as
*                shown in the table below.  The designations (left,
*                centre, right and top, centre, bottom) refer to
*                positions of the box containing the string before the
*                string is rotated to the desired plotting angle.
*                          Left     Centre    Right
*                    Top     2---------5---------8
*                    Centre  1         4         7
*                    Bottom  0---------3---------6
* I ->  IEXP   - Exponent of the scale factor
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:30:59 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE SFPW10 (IX0, IY0, ICENT, IEXP)


      INTEGER IX0,IY0,ICENT,IEXP
      INTEGER NC,IW,IH,ICENTW,ICENTH,IXR,IYR,IXC,IYC,IWN,IHN

      REAL ANG,W,H,Y,X

      CHARACTER*3 SLABEL


* Convert the exponent to a character string
      CALL LABEL(REAL(IEXP),3,SLABEL,NC)

* Get the character size and angle

* Format:
*                                       . . . . .   . o o o .
*                                       .       .   o.      o
*            . . . o . . . .o.o.o.o. .  .       .   .       o
*  . . . . . .  o  o     . o       o .  o o o o o   .   o o .
*  .       . .     o     . o       o .  .       .   .       o
*  o       o .     o     . o       o .  .       .   o       o
*  . o   o . .     o     . o       o .  . . . . .   . o o o .
*  .   o   . .     o     . o       o .
*  . o   o . .     o     . o       o .
*  o . . . o .     o     . o       o .
*            .     o     . o       o .  |----(1.5*n-0.5)----|
*            . .o. o .o. . .o.o.o.o. .
*
*  |--(1)--|-|---(1.5)---|---(1.5)---|--|--(1)--|---|--(1)--|
*  |      (1/4)                      (3/8)      (1/2)       |
*  a          units of character widths                     b
*
* The width of the plotted characters is (4.125+1.5*n)*W,
* where n is the number of characters in the representation of the
* exponent and W is the character width for the small characters.
* The height of the plotted characters is 1.75*H where H is the
* height of the small characters

* Width centering
      CALL GETCHR(IW,IH,ANG)
      ICENTW=ICENT/3
      IF (ICENTW.EQ.0) THEN
        W=0.0
      ELSE IF (ICENTW.EQ.1) THEN
        W=(2.0625+0.75*NC)*IW
      ELSE
        W=(4.125+1.5*NC)*IW
      END IF

* Height centering
      ICENTH=MOD(ICENT,3)
      IF (ICENTH.EQ.0) THEN
        H=0.0
      ELSE IF (ICENTH.EQ.1) THEN
        H=0.875*IH
      ELSE
        H=1.75*IH
      END IF

* Calculate the rotated offset
* (IXC,IYC) is in the lower left hand corner
      CALL ROTPTC(W,H,ANG,IXR,IYR)
      IXC=IX0-IXR
      IYC=IY0-IYR

* Print the scale factor
*   Small characters
      Y=0.25*IH
      CALL ROTPTC(0.0,Y,ANG,IXR,IYR)
      CALL PLTEXT(IXC+IXR,IYC+IYR,0,'x')

      X=4.625*IW
      Y=0.75*IH
      CALL ROTPTC(X,Y,ANG,IXR,IYR)
      CALL PLTEXT(IXC+IXR,IYC+IYR,0,SLABEL(1:NC))

*   Large characters: set the character size
      IWN=NINT(1.5*IW)
      IHN=NINT(1.5*IH)
      CALL SETCHR(IWN,IHN,ANG)

      X=1.25*IW
      CALL ROTPTC(X,0.0,ANG,IXR,IYR)
      CALL PLTEXT(IXC+IXR,IYC+IYR,0,'1')

      X=2.75*IW
      CALL ROTPTC(X,0.0,ANG,IXR,IYR)
      CALL PLTEXT(IXC+IXR,IYC+IYR,0,'0')

* Restore the character sizes
      CALL SETCHR(IW,IH,ANG)


      RETURN

      END
