*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE ROTPTC (XC, YC, ANGD, IXR, IYR)
*
*
* Purpose:
*     Rotate coordinates
*
*
* Description:
*     This routine rotates a given coordinate pair (IX,IY) through the
*     angle ANGD (degrees).  This operation can be expressed in matrix
*     form as
*
*       | IXR |   | cos(ang) -sin(ang)|   | XC |
*       |     | = |                   | * |    |
*       | IYR |   | sin(ang)  cos(ang)|   | YC |
*
*
* Parameters:
* R ->  XC     - X coordinate (real value)
* R ->  YC     - Y coordinate (real value)
* R ->  ANGD   - angle in degrees
* I <-  IXR    - rotated X coordinate (integer value)
* I <-  IYR    - rotated Y coordinate (integer value)
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:30:56 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE ROTPTC (XC, YC, ANGD, IXR, IYR)


      REAL PI
      PARAMETER (PI=3.141 592 654)

      INTEGER IXR,IYR

      REAL XC,YC,ANGD
      REAL CS,SI


* Rotate the coordinates
      CS=COS(ANGD*(PI/180.))
      SI=SIN(ANGD*(PI/180.))
      IXR=NINT(CS*XC-SI*YC)
      IYR=NINT(SI*XC+CS*YC)


      RETURN

      END
