*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE PLCHAR (IX0, IY0, CHAR)
*
*
* Purpose:
*     Plot a character
*
*
* Description:
*     The given character is plotted at the given plotting coordinates.
*     Characters are defined on a 10 by 14 grid.  However, many
*     characters use only the even valued grid points, resulting in an
*     effective 5 by 7 point grid for these characters.  Characters are
*     drawn by joining points on the grid.
*
*     Each point is stored as an X-Y pair in a byte, 4 bits for each
*     coordinate.  In addition special byte values define codes which
*     specify pen up and characters with descenders.
*
*     The printable characters are those in the 7 bit ASCII table
*     (position 32 (space) to position 126 (tilde)) and the 8 bit ASCII
*     table corresponding to the ISO Latin Alphabet Nr. 1.  These
*     latter characters include accented letters.  Some changes have
*     been made to the 8 bit table to include plotting symbols and some
*     additional characters as noted below.  Control characters print
*     as the corresponding two digit hexadecimal code placed within a
*     single character space.
*       Modifications to ISO Latin Alphabet Nr. 1:
*       ASCII   character                replaces
*        161   square                   inverted !
*        162   octagon (circle)         cent sign
*        163   triangle                 pound sign
*        164   inverted triangle        currency sign
*        165   ex                       yen sign
*        166   cross (+)                broken vertical bar
*        167   filled square            section sign
*        168   filled octagon           diaresis
*        169   filled triangle          copyright sign
*        170   filled inverted triangle feminine ordinal
*        180   sigma                    acute accent
*        182   pi                       paragraph sign
*
*
* Parameters:
* I ->  IX0    - X coordinate of the corner of the character (lower
*                left hand corner for characters plotted parallel to
*                the X direction)
* I ->  IY0    - Y coordinate of the corner of the character (lower
*                left hand corner for characters plotted parallel to
*                the X direction)
* C ->  CHAR   - Character to be plotted
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.5 $  $Date: 1995/03/08 15:30:52 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE PLCHAR (IX0, IY0, CHAR)


      INTEGER IX0,IY0
      INTEGER I,IT,IC,NB

      CHARACTER*1 CHAR


* Define types for the parameter values
      INTEGER
     - L0,   L1,   L2,   L3,   L4,   L5,   L6,   L7,
     - L8,   L9,   L10,  L11,  L12,  L13,  L14,  L15,
     - L16,  L17,  L18,  L19,  L20,  L21,  L22,  L23,
     - L24,  L25,  L26,  L27,  L28,  L29,  L30,  L31
      INTEGER
     - L32,  L33,  L34,  L35,  L36,  L37,  L38,  L39,
     - L40,  L41,  L42,  L43,  L44,  L45,  L46,  L47,
     - L48,  L49,  L50,  L51,  L52,  L53,  L54,  L55,
     - L56,  L57,  L58,  L59,  L60,  L61,  L62,  L63
      INTEGER
     - L64,  L65,  L66,  L67,  L68,  L69,  L70,  L71,
     - L72,  L73,  L74,  L75,  L76,  L77,  L78,  L79,
     - L80,  L81,  L82,  L83,  L84,  L85,  L86,  L87,
     - L88,  L89,  L90,  L91,  L92,  L93,  L94,  L95
      INTEGER
     - L96,  L97,  L98,  L99,  L100, L101, L102, L103,
     - L104, L105, L106, L107, L108, L109, L110, L111,
     - L112, L113, L114, L115, L116, L117, L118, L119,
     - L120, L121, L122, L123, L124, L125, L126, L127
      INTEGER
     - L128, L129, L130, L131, L132, L133, L134, L135,
     - L136, L137, L138, L139, L140, L141, L142, L143,
     - L144, L145, L146, L147, L148, L149, L150, L151,
     - L152, L153, L154, L155, L156, L157, L158, L159
      INTEGER
     - L160, L161, L162, L163, L164, L165, L166, L167,
     - L168, L169, L170, L171, L172, L173, L174, L175,
     - L176, L177, L178, L179, L180, L181, L182, L183,
     - L184, L185, L186, L187, L188, L189, L190, L191
      INTEGER
     - L192, L193, L194, L195, L196, L197, L198, L199,
     - L200, L201, L202, L203, L204, L205, L206, L207,
     - L208, L209, L210, L211, L212, L213, L214, L215,
     - L216, L217, L218, L219, L220, L221, L222, L223
      INTEGER
     - L224, L225, L226, L227, L228, L229, L230, L231,
     - L232, L233, L234, L235, L236, L237, L238, L239,
     - L240, L241, L242, L243, L244, L245, L246, L247,
     - L248, L249, L250, L251, L252, L253, L254, L255
      INTEGER
     - IP0,   IP1,   IP2,   IP3,   IP4,   IP5,   IP6,   IP7,
     - IP8,   IP9,   IP10,  IP11,  IP12,  IP13,  IP14,  IP15,
     - IP16,  IP17,  IP18,  IP19,  IP20,  IP21,  IP22,  IP23,
     - IP24,  IP25,  IP26,  IP27,  IP28,  IP29,  IP30,  IP31
      INTEGER
     - IP32,  IP33,  IP34,  IP35,  IP36,  IP37,  IP38,  IP39,
     - IP40,  IP41,  IP42,  IP43,  IP44,  IP45,  IP46,  IP47,
     - IP48,  IP49,  IP50,  IP51,  IP52,  IP53,  IP54,  IP55,
     - IP56,  IP57,  IP58,  IP59,  IP60,  IP61,  IP62,  IP63
      INTEGER
     - IP64,  IP65,  IP66,  IP67,  IP68,  IP69,  IP70,  IP71,
     - IP72,  IP73,  IP74,  IP75,  IP76,  IP77,  IP78,  IP79,
     - IP80,  IP81,  IP82,  IP83,  IP84,  IP85,  IP86,  IP87,
     - IP88,  IP89,  IP90,  IP91,  IP92,  IP93,  IP94,  IP95
      INTEGER
     - IP96,  IP97,  IP98,  IP99,  IP100, IP101, IP102, IP103,
     - IP104, IP105, IP106, IP107, IP108, IP109, IP110, IP111,
     - IP112, IP113, IP114, IP115, IP116, IP117, IP118, IP119,
     - IP120, IP121, IP122, IP123, IP124, IP125, IP126, IP127
      INTEGER
     - IP128, IP129, IP130, IP131, IP132, IP133, IP134, IP135,
     - IP136, IP137, IP138, IP139, IP140, IP141, IP142, IP143,
     - IP144, IP145, IP146, IP147, IP148, IP149, IP150, IP151,
     - IP152, IP153, IP154, IP155, IP156, IP157, IP158, IP159
      INTEGER
     - IP160, IP161, IP162, IP163, IP164, IP165, IP166, IP167,
     - IP168, IP169, IP170, IP171, IP172, IP173, IP174, IP175,
     - IP176, IP177, IP178, IP179, IP180, IP181, IP182, IP183,
     - IP184, IP185, IP186, IP187, IP188, IP189, IP190, IP191
      INTEGER
     - IP192, IP193, IP194, IP195, IP196, IP197, IP198, IP199,
     - IP200, IP201, IP202, IP203, IP204, IP205, IP206, IP207,
     - IP208, IP209, IP210, IP211, IP212, IP213, IP214, IP215,
     - IP216, IP217, IP218, IP219, IP220, IP221, IP222, IP223
      INTEGER
     - IP224, IP225, IP226, IP227, IP228, IP229, IP230, IP231,
     - IP232, IP233, IP234, IP235, IP236, IP237, IP238, IP239,
     - IP240, IP241, IP242, IP243, IP244, IP245, IP246, IP247,
     - IP248, IP249, IP250, IP251, IP252, IP253, IP254, IP255
      INTEGER
     - IP256

      INTEGER
     - X0Y0,   X0Y1,   X0Y2,   X0Y3,   X0Y4,   X0Y5,   X0Y6,   X0Y7,
     - X0Y8,   X0Y9,   X0Y10,  X0Y11,  X0Y12,  X0Y13,  X0Y14,  X0Y15,
     - X1Y0,   X1Y1,   X1Y2,   X1Y3,   X1Y4,   X1Y5,   X1Y6,   X1Y7,
     - X1Y8,   X1Y9,   X1Y10,  X1Y11,  X1Y12,  X1Y13,  X1Y14,  X1Y15
      INTEGER
     - X2Y0,   X2Y1,   X2Y2,   X2Y3,   X2Y4,   X2Y5,   X2Y6,   X2Y7,
     - X2Y8,   X2Y9,   X2Y10,  X2Y11,  X2Y12,  X2Y13,  X2Y14,  X2Y15,
     - X3Y0,   X3Y1,   X3Y2,   X3Y3,   X3Y4,   X3Y5,   X3Y6,   X3Y7,
     - X3Y8,   X3Y9,   X3Y10,  X3Y11,  X3Y12,  X3Y13,  X3Y14,  X3Y15
      INTEGER
     - X4Y0,   X4Y1,   X4Y2,   X4Y3,   X4Y4,   X4Y5,   X4Y6,   X4Y7,
     - X4Y8,   X4Y9,   X4Y10,  X4Y11,  X4Y12,  X4Y13,  X4Y14,  X4Y15,
     - X5Y0,   X5Y1,   X5Y2,   X5Y3,   X5Y4,   X5Y5,   X5Y6,   X5Y7,
     - X5Y8,   X5Y9,   X5Y10,  X5Y11,  X5Y12,  X5Y13,  X5Y14,  X5Y15
      INTEGER
     - X6Y0,   X6Y1,   X6Y2,   X6Y3,   X6Y4,   X6Y5,   X6Y6,   X6Y7,
     - X6Y8,   X6Y9,   X6Y10,  X6Y11,  X6Y12,  X6Y13,  X6Y14,  X6Y15,
     - X7Y0,   X7Y1,   X7Y2,   X7Y3,   X7Y4,   X7Y5,   X7Y6,   X7Y7,
     - X7Y8,   X7Y9,   X7Y10,  X7Y11,  X7Y12,  X7Y13,  X7Y14,  X7Y15
      INTEGER
     - X8Y0,   X8Y1,   X8Y2,   X8Y3,   X8Y4,   X8Y5,   X8Y6,   X8Y7,
     - X8Y8,   X8Y9,   X8Y10,  X8Y11,  X8Y12,  X8Y13,  X8Y14,  X8Y15,
     - X9Y0,   X9Y1,   X9Y2,   X9Y3,   X9Y4,   X9Y5,   X9Y6,   X9Y7,
     - X9Y8,   X9Y9,   X9Y10,  X9Y11,  X9Y12,  X9Y13,  X9Y14,  X9Y15
      INTEGER
     - X10Y0,  X10Y1,  X10Y2,  X10Y3,  X10Y4,  X10Y5,  X10Y6,  X10Y7,
     - X10Y8,  X10Y9,  X10Y10, X10Y11, X10Y12, X10Y13, X10Y14, X10Y15,
     - X11Y0,  X11Y1,  X11Y2,  X11Y3,  X11Y4,  X11Y5,  X11Y6,  X11Y7,
     - X11Y8,  X11Y9,  X11Y10, X11Y11, X11Y12, X11Y13, X11Y14, X11Y15
      INTEGER
     - X12Y0,  X12Y1,  X12Y2,  X12Y3,  X12Y4,  X12Y5,  X12Y6,  X12Y7,
     - X12Y8,  X12Y9,  X12Y10, X12Y11, X12Y12, X12Y13, X12Y14, X12Y15,
     - X13Y0,  X13Y1,  X13Y2,  X13Y3,  X13Y4,  X13Y5,  X13Y6,  X13Y7,
     - X13Y8,  X13Y9,  X13Y10, X13Y11, X13Y12, X13Y13, X13Y14, X13Y15
      INTEGER
     - X14Y0,  X14Y1,  X14Y2,  X14Y3,  X14Y4,  X14Y5,  X14Y6,  X14Y7,
     - X14Y8,  X14Y9,  X14Y10, X14Y11, X14Y12, X14Y13, X14Y14, X14Y15
      INTEGER
     - PENUP,  SHIFTD, SHIFTU


* Set the character drawing table lengths
      PARAMETER
     -(L0=19,   L1=13,   L2=19,   L3=21,
     - L4=15,   L5=18,   L6=19,   L7=15,
     - L8=22,   L9=19,   L10=20,  L11=20,
     - L12=18,  L13=17,  L14=17,  L15=16)
      PARAMETER
     -(L16=13,  L17=7,   L18=13,  L19=15,
     - L20=9,   L21=12,  L22=13,  L23=9,
     - L24=16,  L25=13,  L26=14,  L27=14,
     - L28=12,  L29=11,  L30=11,  L31=10)
      PARAMETER
     -(L32=0,   L33=8,   L34=13,  L35=11,
     - L36=11,  L37=14,  L38=11,  L39=6,
     - L40=8,   L41=8,   L42=11,  L43=5,
     - L44=7,   L45=2,   L46=5,   L47=2)
      PARAMETER
     -(L48=9,   L49=6,   L50=10,  L51=13,
     - L52=5,   L53=9,   L54=10,  L55=5,
     - L56=16,  L57=10,  L58=11,  L59=13,
     - L60=3,   L61=5,   L62=3,   L63=13)
      PARAMETER
     -(L64=11,  L65=8,   L66=12,  L67=8,
     - L68=7,   L69=7,   L70=6,   L71=9,
     - L72=8,   L73=8,   L74=8,   L75=8,
     - L76=3,   L77=5,   L78=4,   L79=9)
      PARAMETER
     -(L80=7,   L81=12,  L82=9,   L83=10,
     - L84=5,   L85=6,   L86=3,   L87=5,
     - L88=5,   L89=6,   L90=6,   L91=4,
     - L92=2,   L93=4,   L94=3,   L95=3)
      PARAMETER
     -(L96=6,   L97=11,  L98=8,   L99=8,
     - L100=8,  L101=10, L102=8,  L103=13,
     - L104=8,  L105=11, L106=11, L107=8,
     - L108=5,  L109=10, L110=8,  L111=9)
      PARAMETER
     -(L112=11, L113=12, L114=7,  L115=8,
     - L116=8,  L117=7,  L118=3,  L119=9,
     - L120=5,  L121=10, L122=4,  L123=7,
     - L124=2,  L125=7,  L126=4,  L127=12)
      PARAMETER
     -(L128=22, L129=16, L130=22, L131=24,
     - L132=18, L133=21, L134=22, L135=18,
     - L136=25, L137=22, L138=23, L139=23,
     - L140=21, L141=20, L142=20, L143=19)
      PARAMETER
     -(L144=19, L145=13, L146=19, L147=21,
     - L148=15, L149=18, L150=19, L151=15,
     - L152=22, L153=19, L154=20, L155=20,
     - L156=18, L157=17, L158=17, L159=16)
      PARAMETER
     -(L160=0,  L161=5,  L162=9,  L163=4,
     - L164=4,  L165=5,  L166=5,  L167=14,
     - L168=18, L169=13, L170=13, L171=7,
     - L172=3,  L173=2,  L174=18, L175=2)
      PARAMETER
     -(L176=5,  L177=8,  L178=9,  L179=11,
     - L180=9,  L181=10, L182=7,  L183=5,
     - L184=4,  L185=3,  L186=12, L187=7,
     - L188=12, L189=16, L190=20, L191=13)
      PARAMETER
     -(L192=11, L193=11, L194=12, L195=13,
     - L196=20, L197=14, L198=12, L199=12,
     - L200=10, L201=10, L202=11, L203=19,
     - L204=11, L205=11, L206=12, L207=20)
      PARAMETER
     -(L208=10, L209=9,  L210=12, L211=12,
     - L212=13, L213=14, L214=21, L215=5,
     - L216=12, L217=9,  L218=9,  L219=10,
     - L220=18, L221=9,  L222=15, L223=12)
      PARAMETER
     -(L224=14, L225=14, L226=15, L227=16,
     - L228=23, L229=17, L230=19, L231=13,
     - L232=13, L233=13, L234=14, L235=22,
     - L236=9,  L237=9,  L238=9,  L239=17)
      PARAMETER
     -(L240=12, L241=13, L242=12, L243=12,
     - L244=13, L245=14, L246=21, L247=14,
     - L248=12, L249=10, L250=10, L251=11,
     - L252=19, L253=13, L254=9,  L255=22)


* Set up the character pointers
      PARAMETER
     -(IP0=0,          IP1=IP0+L0,     IP2=IP1+L1,     IP3=IP2+L2,
     - IP4=IP3+L3,     IP5=IP4+L4,     IP6=IP5+L5,     IP7=IP6+L6)
      PARAMETER
     -(IP8=IP7+L7,     IP9=IP8+L8,     IP10=IP9+L9,    IP11=IP10+L10,
     - IP12=IP11+L11,  IP13=IP12+L12,  IP14=IP13+L13,  IP15=IP14+L14)
      PARAMETER
     -(IP16=IP15+L15,  IP17=IP16+L16,  IP18=IP17+L17,  IP19=IP18+L18,
     - IP20=IP19+L19,  IP21=IP20+L20,  IP22=IP21+L21,  IP23=IP22+L22)
      PARAMETER
     -(IP24=IP23+L23,  IP25=IP24+L24,  IP26=IP25+L25,  IP27=IP26+L26,
     - IP28=IP27+L27,  IP29=IP28+L28,  IP30=IP29+L29,  IP31=IP30+L30)
      PARAMETER
     -(IP32=IP31+L31,  IP33=IP32+L32,  IP34=IP33+L33,  IP35=IP34+L34,
     - IP36=IP35+L35,  IP37=IP36+L36,  IP38=IP37+L37,  IP39=IP38+L38)
      PARAMETER
     -(IP40=IP39+L39,  IP41=IP40+L40,  IP42=IP41+L41,  IP43=IP42+L42,
     - IP44=IP43+L43,  IP45=IP44+L44,  IP46=IP45+L45,  IP47=IP46+L46)
      PARAMETER
     -(IP48=IP47+L47,  IP49=IP48+L48,  IP50=IP49+L49,  IP51=IP50+L50,
     - IP52=IP51+L51,  IP53=IP52+L52,  IP54=IP53+L53,  IP55=IP54+L54)
      PARAMETER
     -(IP56=IP55+L55,  IP57=IP56+L56,  IP58=IP57+L57,  IP59=IP58+L58,
     - IP60=IP59+L59,  IP61=IP60+L60,  IP62=IP61+L61,  IP63=IP62+L62)
      PARAMETER
     -(IP64=IP63+L63,  IP65=IP64+L64,  IP66=IP65+L65,  IP67=IP66+L66,
     - IP68=IP67+L67,  IP69=IP68+L68,  IP70=IP69+L69,  IP71=IP70+L70)
      PARAMETER
     -(IP72=IP71+L71,  IP73=IP72+L72,  IP74=IP73+L73,  IP75=IP74+L74,
     - IP76=IP75+L75,  IP77=IP76+L76,  IP78=IP77+L77,  IP79=IP78+L78)
      PARAMETER
     -(IP80=IP79+L79,  IP81=IP80+L80,  IP82=IP81+L81,  IP83=IP82+L82,
     - IP84=IP83+L83,  IP85=IP84+L84,  IP86=IP85+L85,  IP87=IP86+L86)
      PARAMETER
     -(IP88=IP87+L87,  IP89=IP88+L88,  IP90=IP89+L89,  IP91=IP90+L90,
     - IP92=IP91+L91,  IP93=IP92+L92,  IP94=IP93+L93,  IP95=IP94+L94)
      PARAMETER
     -(IP96=IP95+L95,    IP97=IP96+L96,
     - IP98=IP97+L97,    IP99=IP98+L98,
     - IP100=IP99+L99,   IP101=IP100+L100,
     - IP102=IP101+L101, IP103=IP102+L102)
      PARAMETER
     -(IP104=IP103+L103, IP105=IP104+L104,
     - IP106=IP105+L105, IP107=IP106+L106,
     - IP108=IP107+L107, IP109=IP108+L108,
     - IP110=IP109+L109, IP111=IP110+L110)
      PARAMETER
     -(IP112=IP111+L111, IP113=IP112+L112,
     - IP114=IP113+L113, IP115=IP114+L114,
     - IP116=IP115+L115, IP117=IP116+L116,
     - IP118=IP117+L117, IP119=IP118+L118)
      PARAMETER
     -(IP120=IP119+L119, IP121=IP120+L120,
     - IP122=IP121+L121, IP123=IP122+L122,
     - IP124=IP123+L123, IP125=IP124+L124,
     - IP126=IP125+L125, IP127=IP126+L126)
      PARAMETER
     -(IP128=IP127+L127, IP129=IP128+L128,
     - IP130=IP129+L129, IP131=IP130+L130,
     - IP132=IP131+L131, IP133=IP132+L132,
     - IP134=IP133+L133, IP135=IP134+L134)
      PARAMETER
     -(IP136=IP135+L135, IP137=IP136+L136,
     - IP138=IP137+L137, IP139=IP138+L138,
     - IP140=IP139+L139, IP141=IP140+L140,
     - IP142=IP141+L141, IP143=IP142+L142)
      PARAMETER
     -(IP144=IP143+L143, IP145=IP144+L144,
     - IP146=IP145+L145, IP147=IP146+L146,
     - IP148=IP147+L147, IP149=IP148+L148,
     - IP150=IP149+L149, IP151=IP150+L150)
      PARAMETER
     -(IP152=IP151+L151, IP153=IP152+L152,
     - IP154=IP153+L153, IP155=IP154+L154,
     - IP156=IP155+L155, IP157=IP156+L156,
     - IP158=IP157+L157, IP159=IP158+L158)
      PARAMETER
     -(IP160=IP159+L159, IP161=IP160+L160,
     - IP162=IP161+L161, IP163=IP162+L162,
     - IP164=IP163+L163, IP165=IP164+L164,
     - IP166=IP165+L165, IP167=IP166+L166)
      PARAMETER
     -(IP168=IP167+L167, IP169=IP168+L168,
     - IP170=IP169+L169, IP171=IP170+L170,
     - IP172=IP171+L171, IP173=IP172+L172,
     - IP174=IP173+L173, IP175=IP174+L174)
      PARAMETER
     -(IP176=IP175+L175, IP177=IP176+L176,
     - IP178=IP177+L177, IP179=IP178+L178,
     - IP180=IP179+L179, IP181=IP180+L180,
     - IP182=IP181+L181, IP183=IP182+L182)
      PARAMETER
     -(IP184=IP183+L183, IP185=IP184+L184,
     - IP186=IP185+L185, IP187=IP186+L186,
     - IP188=IP187+L187, IP189=IP188+L188,
     - IP190=IP189+L189, IP191=IP190+L190)
      PARAMETER
     -(IP192=IP191+L191, IP193=IP192+L192,
     - IP194=IP193+L193, IP195=IP194+L194,
     - IP196=IP195+L195, IP197=IP196+L196,
     - IP198=IP197+L197, IP199=IP198+L198)
      PARAMETER
     -(IP200=IP199+L199, IP201=IP200+L200,
     - IP202=IP201+L201, IP203=IP202+L202,
     - IP204=IP203+L203, IP205=IP204+L204,
     - IP206=IP205+L205, IP207=IP206+L206)
      PARAMETER
     -(IP208=IP207+L207, IP209=IP208+L208,
     - IP210=IP209+L209, IP211=IP210+L210,
     - IP212=IP211+L211, IP213=IP212+L212,
     - IP214=IP213+L213, IP215=IP214+L214)
      PARAMETER
     -(IP216=IP215+L215, IP217=IP216+L216,
     - IP218=IP217+L217, IP219=IP218+L218,
     - IP220=IP219+L219, IP221=IP220+L220,
     - IP222=IP221+L221, IP223=IP222+L222)
      PARAMETER
     -(IP224=IP223+L223, IP225=IP224+L224,
     - IP226=IP225+L225, IP227=IP226+L226,
     - IP228=IP227+L227, IP229=IP228+L228,
     - IP230=IP229+L229, IP231=IP230+L230)
      PARAMETER
     -(IP232=IP231+L231, IP233=IP232+L232,
     - IP234=IP233+L233, IP235=IP234+L234,
     - IP236=IP235+L235, IP237=IP236+L236,
     - IP238=IP237+L237, IP239=IP238+L238)
      PARAMETER
     -(IP240=IP239+L239, IP241=IP240+L240,
     - IP242=IP241+L241, IP243=IP242+L242,
     - IP244=IP243+L243, IP245=IP244+L244,
     - IP246=IP245+L245, IP247=IP246+L246)
      PARAMETER
     -(IP248=IP247+L247, IP249=IP248+L248,
     - IP250=IP249+L249, IP251=IP250+L250,
     - IP252=IP251+L251, IP253=IP252+L252,
     - IP254=IP253+L253, IP255=IP254+L254)
      PARAMETER
     -(IP256=IP255+L255)


* Coordinate values
      PARAMETER
     -(X0Y0=0,     X0Y1=1,     X0Y2=2,     X0Y3=3,
     - X0Y4=4,     X0Y5=5,     X0Y6=6,     X0Y7=7,
     - X0Y8=8,     X0Y9=9,     X0Y10=10,   X0Y11=11,
     - X0Y12=12,   X0Y13=13,   X0Y14=14,   X0Y15=15)
      PARAMETER
     -(X1Y0=16,    X1Y1=17,    X1Y2=18,    X1Y3=19,
     - X1Y4=20,    X1Y5=21,    X1Y6=22,    X1Y7=23,
     - X1Y8=24,    X1Y9=25,    X1Y10=26,   X1Y11=27,
     - X1Y12=28,   X1Y13=29,   X1Y14=30,   X1Y15=31)
      PARAMETER
     -(X2Y0=32,    X2Y1=33,    X2Y2=34,    X2Y3=35,
     - X2Y4=36,    X2Y5=37,    X2Y6=38,    X2Y7=39,
     - X2Y8=40,    X2Y9=41,    X2Y10=42,   X2Y11=43,
     - X2Y12=44,   X2Y13=45,   X2Y14=46,   X2Y15=47)
      PARAMETER
     -(X3Y0=48,    X3Y1=49,    X3Y2=50,    X3Y3=51,
     - X3Y4=52,    X3Y5=53,    X3Y6=54,    X3Y7=55,
     - X3Y8=56,    X3Y9=57,    X3Y10=58,   X3Y11=59,
     - X3Y12=60,   X3Y13=61,   X3Y14=62,   X3Y15=63)
      PARAMETER
     -(X4Y0=64,    X4Y1=65,    X4Y2=66,    X4Y3=67,
     - X4Y4=68,    X4Y5=69,    X4Y6=70,    X4Y7=71,
     - X4Y8=72,    X4Y9=73,    X4Y10=74,   X4Y11=75,
     - X4Y12=76,   X4Y13=77,   X4Y14=78,   X4Y15=79)
      PARAMETER
     -(X5Y0=80,    X5Y1=81,    X5Y2=82,    X5Y3=83,
     - X5Y4=84,    X5Y5=85,    X5Y6=86,    X5Y7=87,
     - X5Y8=88,    X5Y9=89,    X5Y10=90,   X5Y11=91,
     - X5Y12=92,   X5Y13=93,   X5Y14=94,   X5Y15=95)
      PARAMETER
     -(X6Y0=96,    X6Y1=97,    X6Y2=98,    X6Y3=99,
     - X6Y4=100,   X6Y5=101,   X6Y6=102,   X6Y7=103,
     - X6Y8=104,   X6Y9=105,   X6Y10=106,  X6Y11=107,
     - X6Y12=108,  X6Y13=109,  X6Y14=110,  X6Y15=111)
      PARAMETER
     -(X7Y0=112,   X7Y1=113,   X7Y2=114,   X7Y3=115,
     - X7Y4=116,   X7Y5=117,   X7Y6=118,   X7Y7=119,
     - X7Y8=120,   X7Y9=121,   X7Y10=122,  X7Y11=123,
     - X7Y12=124,  X7Y13=125,  X7Y14=126,  X7Y15=127)
      PARAMETER
     -(X8Y0=128,   X8Y1=129,   X8Y2=130,   X8Y3=131,
     - X8Y4=132,   X8Y5=133,   X8Y6=134,   X8Y7=135,
     - X8Y8=136,   X8Y9=137,   X8Y10=138,  X8Y11=139,
     - X8Y12=140,  X8Y13=141,  X8Y14=142,  X8Y15=143)
      PARAMETER
     -(X9Y0=144,   X9Y1=145,   X9Y2=146,   X9Y3=147,
     - X9Y4=148,   X9Y5=149,   X9Y6=150,   X9Y7=151,
     - X9Y8=152,   X9Y9=153,   X9Y10=154,  X9Y11=155,
     - X9Y12=156,  X9Y13=157,  X9Y14=158,  X9Y15=159)
      PARAMETER
     -(X10Y0=160,  X10Y1=161,  X10Y2=162,  X10Y3=163,
     - X10Y4=164,  X10Y5=165,  X10Y6=166,  X10Y7=167,
     - X10Y8=168,  X10Y9=169,  X10Y10=170, X10Y11=171,
     - X10Y12=172, X10Y13=173, X10Y14=174, X10Y15=175)
      PARAMETER
     -(X11Y0=176,  X11Y1=177,  X11Y2=178,  X11Y3=179,
     - X11Y4=180,  X11Y5=181,  X11Y6=182,  X11Y7=183,
     - X11Y8=184,  X11Y9=185,  X11Y10=186, X11Y11=187,
     - X11Y12=188, X11Y13=189, X11Y14=190, X11Y15=191)
      PARAMETER
     -(X12Y0=192,  X12Y1=193,  X12Y2=194,  X12Y3=195,
     - X12Y4=196,  X12Y5=197,  X12Y6=198,  X12Y7=199,
     - X12Y8=200,  X12Y9=201,  X12Y10=202, X12Y11=203,
     - X12Y12=204, X12Y13=205, X12Y14=206, X12Y15=207)
      PARAMETER
     -(X13Y0=208,  X13Y1=209,  X13Y2=210,  X13Y3=211,
     - X13Y4=212,  X13Y5=213,  X13Y6=214,  X13Y7=215,
     - X13Y8=216,  X13Y9=217,  X13Y10=218, X13Y11=219,
     - X13Y12=220, X13Y13=221, X13Y14=222, X13Y15=223)
      PARAMETER
     -(X14Y0=224,  X14Y1=225,  X14Y2=226,  X14Y3=227,
     - X14Y4=228,  X14Y5=229,  X14Y6=230,  X14Y7=231,
     - X14Y8=232,  X14Y9=233,  X14Y10=234, X14Y11=235,
     - X14Y12=236, X14Y13=237, X14Y14=238, X14Y15=239)
      PARAMETER
     -(PENUP=240,  SHIFTD=241, SHIFTU=242)


      INTEGER IPT(0:256)
      BYTE CHTAB(0:IP256-1)

* Fill in the pointer table
      DATA (IPT(I), I=0,31)
     -/IP0,   IP1,   IP2,   IP3,   IP4,   IP5,   IP6,   IP7,
     - IP8,   IP9,   IP10,  IP11,  IP12,  IP13,  IP14,  IP15,
     - IP16,  IP17,  IP18,  IP19,  IP20,  IP21,  IP22,  IP23,
     - IP24,  IP25,  IP26,  IP27,  IP28,  IP29,  IP30,  IP31/
      DATA (IPT(I), I=32,63)
     -/IP32,  IP33,  IP34,  IP35,  IP36,  IP37,  IP38,  IP39,
     - IP40,  IP41,  IP42,  IP43,  IP44,  IP45,  IP46,  IP47,
     - IP48,  IP49,  IP50,  IP51,  IP52,  IP53,  IP54,  IP55,
     - IP56,  IP57,  IP58,  IP59,  IP60,  IP61,  IP62,  IP63/
      DATA (IPT(I), I=64,95)
     -/IP64,  IP65,  IP66,  IP67,  IP68,  IP69,  IP70,  IP71,
     - IP72,  IP73,  IP74,  IP75,  IP76,  IP77,  IP78,  IP79,
     - IP80,  IP81,  IP82,  IP83,  IP84,  IP85,  IP86,  IP87,
     - IP88,  IP89,  IP90,  IP91,  IP92,  IP93,  IP94,  IP95/
      DATA (IPT(I), I=96,127)
     -/IP96,  IP97,  IP98,  IP99,  IP100, IP101, IP102, IP103,
     - IP104, IP105, IP106, IP107, IP108, IP109, IP110, IP111,
     - IP112, IP113, IP114, IP115, IP116, IP117, IP118, IP119,
     - IP120, IP121, IP122, IP123, IP124, IP125, IP126, IP127/
      DATA (IPT(I), I=128,159)
     -/IP128, IP129, IP130, IP131, IP132, IP133, IP134, IP135,
     - IP136, IP137, IP138, IP139, IP140, IP141, IP142, IP143,
     - IP144, IP145, IP146, IP147, IP148, IP149, IP150, IP151,
     - IP152, IP153, IP154, IP155, IP156, IP157, IP158, IP159/
      DATA (IPT(I), I=160,191)
     -/IP160, IP161, IP162, IP163, IP164, IP165, IP166, IP167,
     - IP168, IP169, IP170, IP171, IP172, IP173, IP174, IP175,
     - IP176, IP177, IP178, IP179, IP180, IP181, IP182, IP183,
     - IP184, IP185, IP186, IP187, IP188, IP189, IP190, IP191/
      DATA (IPT(I), I=192,223)
     -/IP192, IP193, IP194, IP195, IP196, IP197, IP198, IP199,
     - IP200, IP201, IP202, IP203, IP204, IP205, IP206, IP207,
     - IP208, IP209, IP210, IP211, IP212, IP213, IP214, IP215,
     - IP216, IP217, IP218, IP219, IP220, IP221, IP222, IP223/
      DATA (IPT(I), I=224,255)
     -/IP224, IP225, IP226, IP227, IP228, IP229, IP230, IP231,
     - IP232, IP233, IP234, IP235, IP236, IP237, IP238, IP239,
     - IP240, IP241, IP242, IP243, IP244, IP245, IP246, IP247,
     - IP248, IP249, IP250, IP251, IP252, IP253, IP254, IP255/
      DATA IPT(256)
     - /IP256/


* Fill in the character drawing table
      DATA (CHTAB(I), I=IP0,IP4-1)
*  0  NUL
     -/X2Y7,   X1Y8,   X1Y10,  X2Y11,  X3Y11,  X4Y10,
     - X4Y8,   X3Y7,   X2Y7,   PENUP,  X5Y1,   X4Y2,
     - X4Y4,   X5Y5,   X6Y5,   X7Y4,   X7Y2,   X6Y1,
     - X5Y1,
*  1  SOH
     - X2Y7,   X1Y8,   X1Y10,  X2Y11,  X3Y11,  X4Y10,
     - X4Y8,   X3Y7,   X2Y7,   PENUP,  X5Y4,   X6Y5,
     - X6Y1,
*  2  STX
     - X2Y7,   X1Y8,   X1Y10,  X2Y11,  X3Y11,  X4Y10,
     - X4Y8,   X3Y7,   X2Y7,   PENUP,  X4Y4,   X5Y5,
     - X6Y5,   X7Y4,   X6Y3,   X5Y3,   X4Y2,   X4Y1,
     - X7Y1,
*  3  ETX
     - X2Y7,   X1Y8,   X1Y10,  X2Y11,  X3Y11,  X4Y10,
     - X4Y8,   X3Y7,   X2Y7,   PENUP,  X4Y4,   X5Y5,
     - X6Y5,   X7Y4,   X6Y3,   X5Y3,   X6Y3,   X7Y2,
     - X6Y1,   X5Y1,   X4Y2/
      DATA (CHTAB(I), I=IP4,IP8-1)
*  4  EOT
     -/X2Y7,   X1Y8,   X1Y10,  X2Y11,  X3Y11,  X4Y10,
     - X4Y8,   X3Y7,   X2Y7,   PENUP,  X7Y2,   X4Y2,
     - X4Y3,   X6Y5,   X6Y1,
*  5  ENQ
     - X2Y7,   X1Y8,   X1Y10,  X2Y11,  X3Y11,  X4Y10,
     - X4Y8,   X3Y7,   X2Y7,   PENUP,  X7Y5,   X4Y5,
     - X4Y3,   X6Y3,   X7Y2,   X6Y1,   X5Y1,   X4Y2,
*  6  ACK
     - X2Y7,   X1Y8,   X1Y10,  X2Y11,  X3Y11,  X4Y10,
     - X4Y8,   X3Y7,   X2Y7,   PENUP,  X6Y5,   X5Y5,
     - X4Y4,   X4Y2,   X5Y1,   X6Y1,   X7Y2,   X6Y3,
     - X4Y3,
*  7  BEL
     - X2Y7,   X1Y8,   X1Y10,  X2Y11,  X3Y11,  X4Y10,
     - X4Y8,   X3Y7,   X2Y7,   PENUP,  X4Y5,   X7Y5,
     - X7Y4,   X5Y2,   X5Y1/
      DATA (CHTAB(I), I=IP8,IP12-1)
*  8  BS
     -/X2Y7,   X1Y8,   X1Y10,  X2Y11,  X3Y11,  X4Y10,
     - X4Y8,   X3Y7,   X2Y7,   PENUP,  X5Y3,   X4Y2,
     - X5Y1,   X6Y1,   X7Y2,   X6Y3,   X7Y4,   X6Y5,
     - X5Y5,   X4Y4,   X5Y3,   X6Y3,
*  9  HT
     - X2Y7,   X1Y8,   X1Y10,  X2Y11,  X3Y11,  X4Y10,
     - X4Y8,   X3Y7,   X2Y7,   PENUP,  X5Y1,   X6Y1,
     - X7Y2,   X7Y4,   X6Y5,   X5Y5,   X4Y4,   X5Y3,
     - X7Y3,
* 10  LF
     - X2Y7,   X1Y8,   X1Y10,  X2Y11,  X3Y11,  X4Y10,
     - X4Y8,   X3Y7,   X2Y7,   PENUP,  X4Y1,   X4Y4,
     - X5Y5,   X5Y5,   X6Y5,   X7Y4,   X7Y1,   PENUP,
     - X4Y3,   X7Y3,
* 11  VT
     - X2Y7,   X1Y8,   X1Y10,  X2Y11,  X3Y11,  X4Y10,
     - X4Y8,   X3Y7,   X2Y7,   PENUP,  X4Y1,   X4Y5,
     - X6Y5,   X7Y4,   X6Y3,   X4Y3,   X6Y3,   X7Y2,
     - X6Y1,   X4Y1/
        DATA (CHTAB(I), I=IP12,IP16-1)
* 12  FF
     -/X2Y7,   X1Y8,   X1Y10,  X2Y11,  X3Y11,  X4Y10,
     - X4Y8,   X3Y7,   X2Y7,   PENUP,  X7Y4,   X6Y5,
     - X5Y5,   X4Y4,   X4Y2,   X5Y1,   X6Y1,   X7Y2,
* 13  CR
     - X2Y7,   X1Y8,   X1Y10,  X2Y11,  X3Y11,  X4Y10,
     - X4Y8,   X3Y7,   X2Y7,   PENUP,  X4Y1,   X4Y5,
     - X6Y5,   X7Y4,   X7Y2,   X6Y1,   X4Y1,
* 14  SO
     - X2Y7,   X1Y8,   X1Y10,  X2Y11,  X3Y11,  X4Y10,
     - X4Y8,   X3Y7,   X2Y7,   PENUP,  X7Y5,   X4Y5,
     - X4Y1,   X7Y1,   PENUP,  X6Y3,   X4Y3,
* 15  SI
     - X2Y7,   X1Y8,   X1Y10,  X2Y11,  X3Y11,  X4Y10,
     - X4Y8,   X3Y7,   X2Y7,   PENUP,  X7Y5,   X4Y5,
     - X4Y1,   PENUP,  X6Y3,   X4Y3/
      DATA (CHTAB(I), I=IP16,IP20-1)
* 16  DLE
     -/X2Y10,  X3Y11,  X3Y7,   PENUP,  X5Y1,   X4Y2,
     - X4Y4,   X5Y5,   X6Y5,   X7Y4,   X7Y2,   X6Y1,
     - X5Y1,
* 17  DC1
     - X2Y10,  X3Y11,  X3Y7,   PENUP,  X5Y4,   X6Y5,
     - X6Y1,
* 18  DC2
     - X2Y10,  X3Y11,  X3Y7,   PENUP,  X4Y4,   X5Y5,
     - X6Y5,   X7Y4,   X6Y3,   X5Y3,   X4Y2,   X4Y1,
     - X7Y1,
* 19  DC3
     - X2Y10,  X3Y11,  X3Y7,   PENUP,  X4Y4,   X5Y5,
     - X6Y5,   X7Y4,   X6Y3,   X5Y3,   X6Y3,   X7Y2,
     - X6Y1,   X5Y1,   X4Y2/
      DATA (CHTAB(I), I=IP20,IP24-1)
* 20  DC4
     -/X2Y10,  X3Y11,  X3Y7,   PENUP,  X7Y2,   X4Y2,
     - X4Y3,   X6Y5,   X6Y1,
* 21  NAK
     - X2Y10,  X3Y11,  X3Y7,   PENUP,  X7Y5,   X4Y5,
     - X4Y3,   X6Y3,   X7Y2,   X6Y1,   X5Y1,   X4Y2,
* 22  SYN
     - X2Y10,  X3Y11,  X3Y7,   PENUP,  X6Y5,   X5Y5,
     - X4Y4,   X4Y2,   X5Y1,   X6Y1,   X7Y2,   X6Y3,
     - X4Y3,
* 23  ETB
     - X2Y10,  X3Y11,  X3Y7,   PENUP,  X4Y5,   X7Y5,
     - X7Y4,   X5Y2,   X5Y1/
      DATA (CHTAB(I), I=IP24,IP28-1)
* 24  CAN
     -/X2Y10,  X3Y11,  X3Y7,   PENUP,  X5Y3,   X4Y2,
     - X5Y1,   X6Y1,   X7Y2,   X6Y3,   X7Y4,   X6Y5,
     - X5Y5,   X4Y4,   X5Y3,   X6Y3,
* 25  EM
     - X2Y10,  X3Y11,  X3Y7,   PENUP,  X5Y1,   X6Y1,
     - X7Y2,   X7Y4,   X6Y5,   X5Y5,   X4Y4,   X5Y3,
     - X7Y3,
* 26  SUB
     - X2Y10,  X3Y11,  X3Y7,   PENUP,  X4Y1,   X4Y4,
     - X5Y5,   X5Y5,   X6Y5,   X7Y4,   X7Y1,   PENUP,
     - X4Y3,   X7Y3,
* 27  ESC
     - X2Y10,  X3Y11,  X3Y7,   PENUP,  X4Y1,   X4Y5,
     - X6Y5,   X7Y4,   X6Y3,   X4Y3,   X6Y3,   X7Y2,
     - X6Y1,   X4Y1/
      DATA (CHTAB(I), I=IP28,IP32-1)
* 28  FS
     -/X2Y10,  X3Y11,  X3Y7,   PENUP,  X7Y4,   X6Y5,
     - X5Y5,   X4Y4,   X4Y2,   X5Y1,   X6Y1,   X7Y2,
* 29  GS
     - X2Y10,  X3Y11,  X3Y7,   PENUP,  X4Y1,   X4Y5,
     - X6Y5,   X7Y4,   X7Y2,   X6Y1,   X4Y1,
* 30  RS
     - X2Y10,  X3Y11,  X3Y7,   PENUP,  X7Y5,   X4Y5,
     - X4Y1,   X7Y1,   PENUP,  X6Y3,   X4Y3,
* 31  US
     - X2Y10,  X3Y11,  X3Y7,   PENUP,  X7Y5,   X4Y5,
     - X4Y1,   PENUP,  X6Y3,   X4Y3/
      DATA (CHTAB(I), I=IP32,IP36-1)
* 32  SP
     -/
* 33  !
     - X4Y12,  X4Y6,   PENUP,  X4Y0,   X4Y1,   X5Y1,
     - X5Y0,   X4Y0,
* 34  "
     - X0Y6,   X2Y8,   X2Y12,  X0Y12,  X0Y10,  X2Y10,
     - PENUP,  X6Y6,   X8Y8,   X8Y12,  X6Y12,  X6Y10,
     - X8Y10,
* 35  #
     - X2Y2,   X2Y10,  PENUP,  X6Y10,  X6Y2,   PENUP,
     - X0Y8,   X8Y8,   PENUP,  X0Y4,   X8Y4/
      DATA (CHTAB(I), I=IP36,IP40-1)
* 36  $
     -/X0Y2,   X6Y2,   X8Y4,   X6Y6,   X2Y6,   X0Y8,
     - X2Y10,  X8Y10,  PENUP,  X4Y12,  X4Y0,
* 37  %
     - X0Y0,   X8Y12,  PENUP,  X2Y12,  X0Y12,  X0Y10,
     - X2Y10,  X2Y12,  PENUP,  X6Y2,   X8Y2,   X8Y0,
     - X6Y0,   X6Y2,
* 38  &
     - X8Y4,   X4Y0,   X2Y0,   X0Y2,   X0Y4,   X4Y8,
     - X4Y10,  X2Y12,  X0Y10,  X0Y8,   X8Y0,
* 39  '
     - X2Y6,   X4Y8,   X4Y12,  X2Y12,  X2Y10,  X4Y10/
      DATA (CHTAB(I), I=IP40,IP44-1)
* 40  (
     -/X6Y0,   X4Y1,   X3Y2,   X2Y4,   X2Y8,   X3Y10,
     - X4Y11,  X6Y12,
* 41  )
     - X2Y0,   X4Y1,   X5Y2,   X6Y4,   X6Y8,   X5Y10,
     - X4Y11,  X2Y12,
* 42  *
     - X0Y2,   X8Y10,  PENUP,  X0Y10,  X8Y2,   PENUP,
     - X4Y2,   X4Y10,  PENUP,  X0Y6,   X8Y6,
* 43  +
     - X4Y2,   X4Y10,  PENUP,  X0Y6,   X8Y6/
      DATA (CHTAB(I), I=IP44,IP48-1)
* 44  ,
     -/SHIFTD, X2Y0,   X4Y2,   X4Y6,   X2Y6,   X2Y4,
     - X4Y4,
* 45  -
     - X0Y6,   X8Y6,
* 46  .
     - X2Y0,   X2Y2,   X4Y2,   X4Y0,   X2Y0,
* 47  /
     - X0Y0,   X8Y12/
      DATA (CHTAB(I), I=IP48,IP52-1)
* 48  0
     -/X3Y0,   X1Y2,   X1Y10,  X3Y12,  X5Y12,  X7Y10,
     - X7Y2,   X5Y0,   X3Y0,
* 49  1
     - X2Y10,  X4Y12,  X4Y0,   PENUP,  X2Y0,   X6Y0,
* 50  2
     - X0Y10,  X2Y12,  X6Y12,  X8Y10,  X8Y8,   X6Y6,
     - X2Y6,   X0Y4,   X0Y0,   X8Y0,
* 51  3
     - X0Y2,   X2Y0,   X6Y0,   X8Y2,   X8Y4,   X6Y6,
     - X4Y6,   X6Y6,   X8Y8,   X8Y10,  X6Y12,  X2Y12,
     - X0Y10/
      DATA (CHTAB(I), I=IP52,IP56-1)
* 52  4
     -/X6Y0,   X6Y12,  X0Y6,   X0Y4,   X8Y4,
* 53  5
     - X0Y2,   X2Y0,   X6Y0,   X8Y2,   X8Y6,   X6Y8,
     - X0Y8,   X0Y12,  X8Y12,
* 54  6
     - X6Y12,  X4Y12,  X0Y8,   X0Y2,   X2Y0,   X6Y0,
     - X8Y2,   X8Y4,   X6Y6,   X0Y6,
* 55  7
     - X2Y0,   X2Y4,   X8Y10,  X8Y12,  X0Y12/
      DATA (CHTAB(I), I=IP56,IP60-1)
* 56  8
     -/X2Y6,   X0Y4,   X0Y2,   X2Y0,   X6Y0,   X8Y2,
     - X8Y4,   X6Y6,   X2Y6,   X0Y8,   X0Y10,  X2Y12,
     - X6Y12,  X8Y10,  X8Y8,   X6Y6,
* 57  9
     - X2Y0,   X4Y0,   X8Y4,   X8Y10,  X6Y12,  X2Y12,
     - X0Y10,  X0Y8,   X2Y6,   X8Y6,
* 58  :
     - X2Y6,   X2Y8,   X4Y8,   X4Y6,   X2Y6,   PENUP,
     - X2Y0,   X2Y2,   X4Y2,   X4Y0,   X2Y0,
* 59  ;
     - X2Y6,   X2Y8,   X4Y8,   X4Y6,   X2Y6,   PENUP,
     - SHIFTD, X2Y0,   X4Y2,   X4Y6,   X2Y6,   X2Y4,
     - X4Y4/
      DATA (CHTAB(I), I=IP60,IP64-1)
* 60  <
     -/X8Y12,  X2Y6,   X8Y0,
* 61  =
     - X0Y8,   X8Y8,   PENUP,  X0Y4,   X8Y4,
* 62  >
     - X0Y0,   X6Y6,   X0Y12,
* 63  ?
     - X0Y10,  X2Y12,  X4Y12,  X6Y10,  X6Y8,   X4Y6,
     - X4Y4,   PENUP,  X4Y1,   X4Y0,   X5Y0,   X5Y1,
     - X4Y1/
      DATA (CHTAB(I), I=IP64,IP68-1)
* 64  @
     -/X8Y8,   X4Y8,   X4Y4,   X8Y4,   X8Y10,  X6Y12,
     - X2Y12,  X0Y10,  X0Y2,   X2Y0,   X8Y0,
* 65  A
     - X0Y0,   X0Y8,   X4Y12,  X8Y8,   X8Y0,   PENUP,
     - X0Y4,   X8Y4,
* 66  B
     - X0Y0,   X0Y12,  X6Y12,  X8Y10,  X8Y8,   X6Y6,
     - X0Y6,   X6Y6,   X8Y4,   X8Y2,   X6Y0,   X0Y0,
* 67  C
     - X8Y2,   X6Y0,   X2Y0,   X0Y2,   X0Y10,  X2Y12,
     - X6Y12,  X8Y10/
      DATA (CHTAB(I), I=IP68,IP72-1)
* 68  D
     -/X0Y0,   X0Y12,  X6Y12,  X8Y10,  X8Y2,   X6Y0,
     - X0Y0,
* 69  E
     - X8Y0,   X0Y0,   X0Y12,  X8Y12,  PENUP,  X0Y6,
     - X4Y6,
* 70  F
     - X0Y0,   X0Y12,  X8Y12,  PENUP,  X0Y6,   X4Y6,
* 71  G
     - X6Y4,   X8Y4,   X8Y0,   X2Y0,   X0Y2,   X0Y10,
     - X2Y12,  X6Y12,  X8Y10/
      DATA (CHTAB(I), I=IP72,IP76-1)
* 72  H
     -/X0Y0,   X0Y12,  PENUP,  X0Y6,   X8Y6,   PENUP,
     - X8Y12,  X8Y0,
* 73  I
     - X2Y12,  X6Y12,  PENUP,  X4Y12,  X4Y0,   PENUP,
     - X2Y0,   X6Y0,
* 74  J
     - X4Y12,  X8Y12,  PENUP,  X6Y12,  X6Y2,   X4Y0,
     - X2Y0,   X0Y2,
* 75  K
     - X0Y0,   X0Y12,  PENUP,  X8Y12,  X2Y6,   X0Y6,
     - X2Y6,   X8Y0/
      DATA (CHTAB(I), I=IP76,IP80-1)
* 76  L
     -/X0Y12,  X0Y0,   X8Y0,
* 77  M
     - X0Y0,   X0Y12,  X4Y8,   X8Y12,  X8Y0,
* 78  N
     - X0Y0,   X0Y12,  X8Y0,   X8Y12,
* 79  O
     - X2Y0,   X0Y2,   X0Y10,  X2Y12,  X6Y12,  X8Y10,
     - X8Y2,   X6Y0,   X2Y0/
      DATA (CHTAB(I), I=IP80,IP84-1)
* 80  P
     -/X0Y0,   X0Y12,  X6Y12,  X8Y10,  X8Y8,   X6Y6,
     - X0Y6,
* 81  Q
     - X2Y0,   X0Y2,   X0Y10,  X2Y12,  X6Y12,  X8Y10,
     - X8Y2,   X6Y0,   X2Y0,   PENUP,  X6Y2,   X8Y0,
* 82  R
     - X0Y0,   X0Y12,  X6Y12,  X8Y10,  X8Y8,   X6Y6,
     - X0Y6,   X2Y6,   X8Y0,
* 83  S
     - X0Y0,   X6Y0,   X8Y2,   X8Y4,   X6Y6,   X2Y6,
     - X0Y8,   X0Y10,  X2Y12,  X8Y12/
      DATA (CHTAB(I), I=IP84,IP88-1)
* 84  T
     -/X0Y12,  X8Y12,  PENUP,  X4Y12,  X4Y0,
* 85  U
     - X0Y12,  X0Y2,   X2Y0,   X6Y0,   X8Y2,   X8Y12,
* 86  V
     - X0Y12,  X4Y0,   X8Y12,
* 87  W
     - X0Y12,  X0Y0,   X4Y4,   X8Y0,   X8Y12/
      DATA (CHTAB(I), I=IP88,IP92-1)
* 88  X
     -/X0Y0,   X8Y12,  PENUP,  X0Y12,  X8Y0,
* 89  Y
     - X0Y12,  X4Y6,   X8Y12,  PENUP,  X4Y6,   X4Y0,
* 90  Z
     - X0Y12,  X8Y12,  X8Y10,  X0Y2,   X0Y0,   X8Y0,
* 91  [
     - X6Y12,  X2Y12,  X2Y0,   X6Y0/
      DATA (CHTAB(I), I=IP92,IP96-1)
* 92  \
     -/X0Y12,  X8Y0,
* 93  ]
     - X2Y12,  X6Y12,  X6Y0,   X2Y0,
* 94  ^
     - X0Y8,   X4Y12,  X8Y8,
* 95  _
     - SHIFTD, X0Y2,   X8Y2/
      DATA (CHTAB(I), I=IP96,IP100-1)
* 96  `
     -/X4Y10,  X6Y10,  X6Y12,  X4Y12,  X4Y8,   X6Y6,
* 97  a
     - X0Y7,   X1Y8,   X4Y8,   X6Y6,   X6Y0,   X8Y0,
     - X1Y0,   X0Y1,   X0Y3,   X1Y4,   X6Y4,
* 98  b
     - X0Y12,  X0Y0,   X6Y0,   X8Y2,   X8Y6,   X6Y8,
     - X2Y8,   X0Y6,
* 99  c
     - X8Y6,   X6Y8,   X2Y8,   X0Y6,   X0Y2,   X2Y0,
     - X6Y0,   X8Y2/
      DATA (CHTAB(I), I=IP100,IP104-1)
*100  d
     -/X8Y12,  X8Y0,   X2Y0,   X0Y2,   X0Y6,   X2Y8,
     - X6Y8,   X8Y6,
*101  e
     - X8Y1,   X6Y0,   X2Y0,   X0Y2,   X0Y6,   X2Y8,
     - X6Y8,   X8Y6,   X7Y4,   X0Y4,
*102  f
     - X2Y0,   X2Y10,  X4Y12,  X6Y12,  X8Y10,  PENUP,
     - X0Y6,   X4Y6,
*103  g
     - SHIFTD, X2Y0,   X6Y0,   X8Y2,   X8Y12,  PENUP,
     - X8Y10,  X6Y12,  X2Y12,  X0Y10,  X0Y6,   X2Y4,
     - X8Y4/
      DATA (CHTAB(I), I=IP104,IP108-1)
*104  h
     -/X0Y0,   X0Y12,  PENUP,  X0Y6,   X2Y8,   X6Y8,
     - X8Y6,   X8Y0,
*105  i
     - X3Y12,  X3Y13,  X4Y13,  X4Y12,  X3Y12,  PENUP,
     - X3Y8,   X4Y8,   X4Y0,   X3Y0,   X5Y0,
*106  j
     - SHIFTD, X4Y14,  X4Y15,  X5Y15,  X5Y14,  X4Y14,
     - PENUP,  X5Y10,  X5Y2,   X2Y0,   X0Y2,
*107  k
     - X2Y0,   X2Y12,  PENUP,  X2Y2,   X8Y8,   PENUP,
     - X4Y4,   X8Y0/
      DATA (CHTAB(I), I=IP108,IP112-1)
*108  l
     -/X3Y12,  X4Y12,  X4Y0,   X3Y0,   X5Y0,
*109  m
     - X0Y0,   X0Y8,   X0Y6,   X2Y8,   X4Y6,   X4Y4,
     - X4Y6,   X6Y8,   X8Y6,   X8Y0,
*110  n
     - X0Y0,   X0Y8,   PENUP,  X0Y6,   X2Y8,   X6Y8,
     - X8Y6,   X8Y0,
*111  o
     - X0Y2,   X0Y6,   X2Y8,   X6Y8,   X8Y6,   X8Y2,
     - X6Y0,   X2Y0,   X0Y2/
      DATA (CHTAB(I), I=IP112,IP116-1)
*112  p
     -/SHIFTD, X0Y0,   X0Y12,  PENUP,  X0Y10,  X2Y12,
     - X6Y12,  X8Y10,  X8Y6,   X6Y4,   X0Y4,
*113  q
     - SHIFTD, X8Y0,   X8Y12,  PENUP,  X8Y6,   X6Y4,
     - X2Y4,   X0Y6,   X0Y10,  X2Y12,  X6Y12,  X8Y10,
*114  r
     - X0Y0,   X0Y8,   PENUP,  X0Y6,   X2Y8,   X6Y8,
     - X8Y6,
*115  s
     - X0Y0,   X6Y0,   X8Y2,   X6Y4,   X2Y4,   X0Y6,
     - X2Y8,   X8Y8/
      DATA (CHTAB(I), I=IP116,IP120-1)
*116  t
     -/X2Y12,  X2Y2,   X4Y0,   X6Y0,   X8Y2,   PENUP,
     - X0Y8,   X6Y8,
*117  u
     - X0Y8,   X0Y2,   X2Y0,   X6Y0,   X8Y2,   X8Y8,
     - X8Y0,
*118  v
     - X0Y8,   X4Y0,   X8Y8,
*119  w
     - X0Y8,   X0Y2,   X2Y0,   X4Y2,   X4Y4,   X4Y2,
     - X6Y0,   X8Y2,   X8Y8/
      DATA (CHTAB(I), I=IP120,IP124-1)
*120  x
     -/X0Y0,   X8Y8,   PENUP,  X0Y8,   X8Y0,
*121  y
     - SHIFTD, X0Y12,  X0Y6,   X2Y4,   X6Y4,   X8Y6,
     - X8Y12,  X8Y2,   X6Y0,   X2Y0,
*122  z
     - X0Y8,   X8Y8,   X0Y0,   X8Y0,
*123  {
     - X6Y12,  X4Y10,  X4Y8,   X2Y6,   X4Y4,   X4Y2,
     - X6Y0/
      DATA (CHTAB(I), I=IP124,IP128-1)
*124  |
     -/X4Y0,   X4Y12,
*125  }
     - X2Y12,  X4Y10,  X4Y8,   X6Y6,   X4Y4,   X4Y2,
     - X2Y0,
*126  ~
     - X0Y5,   X2Y7,   X6Y5,   X8Y7,
*127  DEL
     - X1Y11,  X4Y11,  X4Y10,  X2Y8,   X2Y7,   PENUP,
     - X7Y5,   X4Y5,   X4Y1,   PENUP,  X6Y3,   X4Y3/
      DATA (CHTAB(I), I=IP128,IP132-1)
*128  -
     -/X2Y9,   X1Y8,   X2Y7,   X3Y7,   X4Y8,   X3Y9,
     - X4Y10,  X3Y11,  X2Y11,  X1Y10,  X2Y9,   X3Y9,
     - PENUP,  X5Y1,   X4Y2,   X4Y4,   X5Y5,   X6Y5,
     - X7Y4,   X7Y2,   X6Y1,   X5Y1,
*129  -
     - X2Y9,   X1Y8,   X2Y7,   X3Y7,   X4Y8,   X3Y9,
     - X4Y10,  X3Y11,  X2Y11,  X1Y10,  X2Y9,   X3Y9,
     - PENUP,  X5Y4,   X6Y5,   X6Y1,
*130  -
     - X2Y9,   X1Y8,   X2Y7,   X3Y7,   X4Y8,   X3Y9,
     - X4Y10,  X3Y11,  X2Y11,  X1Y10,  X2Y9,   X3Y9,
     - PENUP,  X4Y4,   X5Y5,   X6Y5,   X7Y4,   X6Y3,
     - X5Y3,   X4Y2,   X4Y1,   X7Y1,
*131  -
     - X2Y9,   X1Y8,   X2Y7,   X3Y7,   X4Y8,   X3Y9,
     - X4Y10,  X3Y11,  X2Y11,  X1Y10,  X2Y9,   X3Y9,
     - PENUP,  X4Y4,   X5Y5,   X6Y5,   X7Y4,   X6Y3,
     - X5Y3,   X6Y3,   X7Y2,   X6Y1,   X5Y1,   X4Y2/
      DATA (CHTAB(I), I=IP132,IP136-1)
*132  IND
     -/X2Y9,   X1Y8,   X2Y7,   X3Y7,   X4Y8,   X3Y9,
     - X4Y10,  X3Y11,  X2Y11,  X1Y10,  X2Y9,   X3Y9,
     - PENUP,  X7Y2,   X4Y2,   X4Y3,   X6Y5,   X6Y1,
*133  NEL
     - X2Y9,   X1Y8,   X2Y7,   X3Y7,   X4Y8,   X3Y9,
     - X4Y10,  X3Y11,  X2Y11,  X1Y10,  X2Y9,   X3Y9,
     - PENUP,  X7Y5,   X4Y5,   X4Y3,   X6Y3,   X7Y2,
     - X6Y1,   X5Y1,   X4Y2,
*134  SSA
     - X2Y9,   X1Y8,   X2Y7,   X3Y7,   X4Y8,   X3Y9,
     - X4Y10,  X3Y11,  X2Y11,  X1Y10,  X2Y9,   X3Y9,
     - PENUP,  X6Y5,   X5Y5,   X4Y4,   X4Y2,   X5Y1,
     - X6Y1,   X7Y2,   X6Y3,   X4Y3,
*135  ESA
     - X2Y9,   X1Y8,   X2Y7,   X3Y7,   X4Y8,   X3Y9,
     - X4Y10,  X3Y11,  X2Y11,  X1Y10,  X2Y9,   X3Y9,
     - PENUP,  X4Y5,   X7Y5,   X7Y4,   X5Y2,   X5Y1/
      DATA (CHTAB(I), I=IP136,IP140-1)
*136  HTS
     -/X2Y9,   X1Y8,   X2Y7,   X3Y7,   X4Y8,   X3Y9,
     - X4Y10,  X3Y11,  X2Y11,  X1Y10,  X2Y9,   X3Y9,
     - PENUP,  X5Y3,   X4Y2,   X5Y1,   X6Y1,   X7Y2,
     - X6Y3,   X7Y4,   X6Y5,   X5Y5,   X4Y4,   X5Y3,
     - X6Y3,
*137  HTJ
     - X2Y9,   X1Y8,   X2Y7,   X3Y7,   X4Y8,   X3Y9,
     - X4Y10,  X3Y11,  X2Y11,  X1Y10,  X2Y9,   X3Y9,
     - PENUP,  X5Y1,   X6Y1,   X7Y2,   X7Y4,   X6Y5,
     - X5Y5,   X4Y4,   X5Y3,   X7Y3,
*138  VTS
     - X2Y9,   X1Y8,   X2Y7,   X3Y7,   X4Y8,   X3Y9,
     - X4Y10,  X3Y11,  X2Y11,  X1Y10,  X2Y9,   X3Y9,
     - PENUP,  X4Y1,   X4Y4,   X5Y5,   X5Y5,   X6Y5,
     - X7Y4,   X7Y1,   PENUP,  X4Y3,   X7Y3,
*139  PLD
     - X2Y9,   X1Y8,   X2Y7,   X3Y7,   X4Y8,   X3Y9,
     - X4Y10,  X3Y11,  X2Y11,  X1Y10,  X2Y9,   X3Y9,
     - PENUP,  X4Y1,   X4Y5,   X6Y5,   X7Y4,   X6Y3,
     - X4Y3,   X6Y3,   X7Y2,   X6Y1,   X4Y1/
      DATA (CHTAB(I), I=IP140,IP144-1)
*140  PLU
     -/X2Y9,   X1Y8,   X2Y7,   X3Y7,   X4Y8,   X3Y9,
     - X4Y10,  X3Y11,  X2Y11,  X1Y10,  X2Y9,   X3Y9,
     - PENUP,  X7Y4,   X6Y5,   X5Y5,   X4Y4,   X4Y2,
     - X5Y1,   X6Y1,   X7Y2,
*141  RI
     - X2Y9,   X1Y8,   X2Y7,   X3Y7,   X4Y8,   X3Y9,
     - X4Y10,  X3Y11,  X2Y11,  X1Y10,  X2Y9,   X3Y9,
     - PENUP,  X4Y1,   X4Y5,   X6Y5,   X7Y4,   X7Y2,
     - X6Y1,   X4Y1,
*142  SS2
     - X2Y9,   X1Y8,   X2Y7,   X3Y7,   X4Y8,   X3Y9,
     - X4Y10,  X3Y11,  X2Y11,  X1Y10,  X2Y9,   X3Y9,
     - PENUP,  X7Y5,   X4Y5,   X4Y1,   X7Y1,   PENUP,
     - X6Y3,   X4Y3,
*143  SS3
     - X2Y9,   X1Y8,   X2Y7,   X3Y7,   X4Y8,   X3Y9,
     - X4Y10,  X3Y11,  X2Y11,  X1Y10,  X2Y9,   X3Y9,
     - PENUP,  X7Y5,   X4Y5,   X4Y1,   PENUP,  X6Y3,
     - X4Y3/
      DATA (CHTAB(I), I=IP144,IP148-1)
*144  DCS
     -/X2Y7,   X3Y7,   X4Y8,   X4Y10,  X3Y11,  X2Y11,
     - X1Y10,  X2Y9,   X4Y9,   PENUP,  X5Y1,   X4Y2,
     - X4Y4,   X5Y5,   X6Y5,   X7Y4,   X7Y2,   X6Y1,
     - X5Y1,
*145  PU1
     - X2Y7,   X3Y7,   X4Y8,   X4Y10,  X3Y11,  X2Y11,
     - X1Y10,  X2Y9,   X4Y9,   PENUP,  X5Y4,   X6Y5,
     - X6Y1,
*146  PU2
     - X2Y7,   X3Y7,   X4Y8,   X4Y10,  X3Y11,  X2Y11,
     - X1Y10,  X2Y9,   X4Y9,   PENUP,  X4Y4,   X5Y5,
     - X6Y5,   X7Y4,   X6Y3,   X5Y3,   X4Y2,   X4Y1,
     - X7Y1,
*147  STS
     - X2Y7,   X3Y7,   X4Y8,   X4Y10,  X3Y11,  X2Y11,
     - X1Y10,  X2Y9,   X4Y9,   PENUP,  X4Y4,   X5Y5,
     - X6Y5,   X7Y4,   X6Y3,   X5Y3,   X6Y3,   X7Y2,
     - X6Y1,   X5Y1,   X4Y2/
      DATA (CHTAB(I), I=IP148,IP152-1)
*148  CCH
     -/X2Y7,   X3Y7,   X4Y8,   X4Y10,  X3Y11,  X2Y11,
     - X1Y10,  X2Y9,   X4Y9,   PENUP,  X7Y2,   X4Y2,
     - X4Y3,   X6Y5,   X6Y1,
*149  MW
     - X2Y7,   X3Y7,   X4Y8,   X4Y10,  X3Y11,  X2Y11,
     - X1Y10,  X2Y9,   X4Y9,   PENUP,  X7Y5,   X4Y5,
     - X4Y3,   X6Y3,   X7Y2,   X6Y1,   X5Y1,   X4Y2,
*150  SPA
     - X2Y7,   X3Y7,   X4Y8,   X4Y10,  X3Y11,  X2Y11,
     - X1Y10,  X2Y9,   X4Y9,   PENUP,  X6Y5,   X5Y5,
     - X4Y4,   X4Y2,   X5Y1,   X6Y1,   X7Y2,   X6Y3,
     - X4Y3,
*151  EPA
     - X2Y7,   X3Y7,   X4Y8,   X4Y10,  X3Y11,  X2Y11,
     - X1Y10,  X2Y9,   X4Y9,   PENUP,  X4Y5,   X7Y5,
     - X7Y4,   X5Y2,   X5Y1/
      DATA (CHTAB(I), I=IP152,IP156-1)
*152  -
     -/X2Y7,   X3Y7,   X4Y8,   X4Y10,  X3Y11,  X2Y11,
     - X1Y10,  X2Y9,   X4Y9,   PENUP,  X5Y3,   X4Y2,
     - X5Y1,   X6Y1,   X7Y2,   X6Y3,   X7Y4,   X6Y5,
     - X5Y5,   X4Y4,   X5Y3,   X6Y3,
*153  -
     - X2Y7,   X3Y7,   X4Y8,   X4Y10,  X3Y11,  X2Y11,
     - X1Y10,  X2Y9,   X4Y9,   PENUP,  X5Y1,   X6Y1,
     - X7Y2,   X7Y4,   X6Y5,   X5Y5,   X4Y4,   X5Y3,
     - X7Y3,
*154  -
     - X2Y7,   X3Y7,   X4Y8,   X4Y10,  X3Y11,  X2Y11,
     - X1Y10,  X2Y9,   X4Y9,   PENUP,  X4Y1,   X4Y4,
     - X5Y5,   X5Y5,   X6Y5,   X7Y4,   X7Y1,   PENUP,
     - X4Y3,   X7Y3,
*155  CSI
     - X2Y7,   X3Y7,   X4Y8,   X4Y10,  X3Y11,  X2Y11,
     - X1Y10,  X2Y9,   X4Y9,   PENUP,  X4Y1,   X4Y5,
     - X6Y5,   X7Y4,   X6Y3,   X4Y3,   X6Y3,   X7Y2,
     - X6Y1,   X4Y1/
      DATA (CHTAB(I), I=IP156,IP160-1)
*156  ST
     -/X2Y7,   X3Y7,   X4Y8,   X4Y10,  X3Y11,  X2Y11,
     - X1Y10,  X2Y9,   X4Y9,   PENUP,  X7Y4,   X6Y5,
     - X5Y5,   X4Y4,   X4Y2,   X5Y1,   X6Y1,   X7Y2,
*157  OSC
     - X2Y7,   X3Y7,   X4Y8,   X4Y10,  X3Y11,  X2Y11,
     - X1Y10,  X2Y9,   X4Y9,   PENUP,  X4Y1,   X4Y5,
     - X6Y5,   X7Y4,   X7Y2,   X6Y1,   X4Y1,
*158  PM
     - X2Y7,   X3Y7,   X4Y8,   X4Y10,  X3Y11,  X2Y11,
     - X1Y10,  X2Y9,   X4Y9,   PENUP,  X7Y5,   X4Y5,
     - X4Y1,   X7Y1,   PENUP,  X6Y3,   X4Y3,
*159  APC
     - X2Y7,   X3Y7,   X4Y8,   X4Y10,  X3Y11,  X2Y11,
     - X1Y10,  X2Y9,   X4Y9,   PENUP,  X7Y5,   X4Y5,
     - X4Y1,   PENUP,  X6Y3,   X4Y3/
      DATA (CHTAB(I), I=IP160,IP164-1)
*160  nb space
     -/
*161  square
     - X0Y2,   X0Y10,  X8Y10,  X8Y2,   X0Y2,
*162  octagon
     - X0Y4,   X0Y8,   X2Y10,  X6Y10,  X8Y8,   X8Y4,
     - X6Y2,   X2Y2,   X0Y4,
*163  triangle
     - X0Y2,   X4Y10,  X8Y2,   X0Y2/
      DATA (CHTAB(I), I=IP164,IP168-1)
*164  inverted triangle
     -/X0Y10,  X8Y10,  X4Y2,   X0Y10,
*165  ex
     - X0Y2,   X8Y10,  PENUP,  X0Y10,  X8Y2,
*166  +
     - X4Y2,   X4Y10,  PENUP,  X0Y6,   X8Y6,
*167  filled square
     - X0Y4,   X8Y4,   PENUP,  X0Y6,   X8Y6,   PENUP,
     - X0Y8,   X8Y8,   PENUP,  X0Y2,   X0Y10,  X8Y10,
     - X8Y2,   X0Y2/
      DATA (CHTAB(I), I=IP168,IP172-1)
*168  filled octagon
     -/X0Y4,   X8Y4,   PENUP,  X0Y6,   X8Y6,   PENUP,
     - X0Y8,   X8Y8,   PENUP,  X0Y4,   X0Y8,   X2Y10,
     - X6Y10,  X8Y8,   X8Y4,   X6Y2,   X2Y2,   X0Y4,
*169  filled triangle
     - X2Y2,   X2Y5,   PENUP,  X4Y2,   X4Y10,  PENUP,
     - X6Y2,   X6Y5,   PENUP,  X0Y2,   X4Y10,  X8Y2,
     - X0Y2,
*170  filled inverted triangle
     - X2Y7,   X2Y10,  PENUP,  X4Y2,   X4Y10,  PENUP,
     - X6Y7,   X6Y10,  PENUP,  X0Y10,  X8Y10,  X4Y2,
     - X0Y10,
*171  <<
     - X4Y2,   X0Y6,   X4Y10,  PENUP,  X8Y2,   X4Y6,
     - X8Y10/
      DATA (CHTAB(I), I=IP172,IP176-1)
*172  -,
     -/X0Y6,   X6Y6,   X6Y4,
*173  -^
     - X1Y10,  X7Y10,
*174  RO
     - X0Y4,   X0Y8,   X2Y10,  X6Y10,  X8Y8,   X8Y4,
     - X6Y2,   X2Y2,   X0Y4,   PENUP,  X2Y4,   X2Y8,
     - X4Y8,   X5Y7,   X4Y6,   X2Y6,   X2Y6,   X5Y4,
*175  --
     - X2Y6,   X6Y6/
      DATA (CHTAB(I), I=IP176,IP180-1)
*176  0^
     -/X4Y10,  X4Y11,  X5Y11,  X5Y10,  X4Y10,
*177  +-
     - X0Y2,   X8Y2,   PENUP,  X0Y6,   X8Y6,   PENUP,
     - X4Y3,   X4Y9,
*178  2^
     - X3Y9,   X4Y10,  X5Y10,  X6Y9,   X5Y8,   X4Y8,
     - X3Y7,   X3Y6,   X6Y6,
*179  3^
     - X3Y9,   X4Y10,  X5Y10,  X6Y9,   X5Y8,   X4Y8,
     - X5Y8,   X6Y7,   X5Y6,   X4Y6,   X3Y7/
      DATA (CHTAB(I), I=IP180,IP184-1)
*180  sigma
     -/X4Y6,   X6Y4,   X6Y2,   X4Y0,   X2Y0,   X0Y2,
     - X0Y4,   X2Y6,   X8Y6,
*181  mu
     - SHIFTD, X0Y0,   X2Y6,   X2Y12,  X2Y6,   X4Y4,
     - X6Y4,   X8Y6,   X8Y12,  X8Y4,
*182  pi
     - X0Y0,   X2Y8,   X0Y7,   X2Y8,   X8Y8,   X6Y8,
     - X6Y0,
*183  .^
     - X4Y6,   X4Y7,   X5Y7,   X5Y6,   X4Y6/
      DATA (CHTAB(I), I=IP184,IP188-1)
*184  ,,
     -/SHIFTD, X3Y0,   X4Y1,   X4Y2,
*185  1^
     - X4Y9,   X5Y10,  X5Y6,
*186  O_
     - X2Y7,   X2Y9,   X3Y10,  X5Y10,  X6Y9,   X6Y7,
     - X5Y6,   X3Y6,   X2Y7,   PENUP,  X2Y4,   X6Y4,
*187  >>
     - X0Y2,   X4Y6,   X0Y10,  PENUP,  X4Y2,   X8Y6,
     - X4Y10/
      DATA (CHTAB(I), I=IP188,IP192-1)
*188  1/4
     -/X2Y10,  X3Y11,  X3Y7,   PENUP,  X6Y1,   X6Y5,
     - X4Y3,   X4Y2,   X7Y2,   PENUP,  X2Y4,   X6Y8,
*189  1/2
     - X2Y10,  X3Y11,  X3Y7,   PENUP,  X4Y4,   X5Y5,
     - X6Y5,   X7Y4,   X6Y3,   X5Y3,   X4Y2,   X4Y1,
     - X7Y1,   PENUP,  X2Y4,   X6Y8,
*190  3/4
     - X1Y10,  X2Y11,  X3Y11,  X4Y10,  X3Y9,   X2Y9,
     - X3Y9,   X4Y8,   X3Y7,   X2Y7,   X1Y8,   PENUP,
     - X6Y1,   X6Y5,   X4Y3,   X4Y2,   X7Y2,   PENUP,
     - X2Y4,   X6Y8,
*191  ??
     - X6Y2,   X4Y0,   X2Y0,   X0Y2,   X0Y4,   X2Y6,
     - X2Y8,   PENUP,  X2Y11,  X1Y11,  X1Y12,  X2Y12,
     - X2Y11/
      DATA (CHTAB(I), I=IP192,IP196-1)
*192  A`
     -/X0Y0,   X0Y8,   X4Y12,  X8Y8,   X8Y0,   PENUP,
     - X0Y4,   X8Y4,   SHIFTU, X2Y12,  X6Y10,
*193  A'
     - X0Y0,   X0Y8,   X4Y12,  X8Y8,   X8Y0,   PENUP,
     - X0Y4,   X8Y4,   SHIFTU, X2Y10,  X6Y12,
*194  A^
     - X0Y0,   X0Y8,   X4Y12,  X8Y8,   X8Y0,   PENUP,
     - X0Y4,   X8Y4,   SHIFTU, X2Y10,  X4Y12,  X6Y10,
*195  A~
     - X0Y0,   X0Y8,   X4Y12,  X8Y8,   X8Y0,   PENUP,
     - X0Y4,   X8Y4,   SHIFTU, X2Y10,  X3Y11,  X5Y10,
     - X6Y11/
      DATA (CHTAB(I), I=IP196,IP200-1)
*196  A"
     -/X0Y0,   X0Y8,   X4Y12,  X8Y8,   X8Y0,   PENUP,
     - X0Y4,   X8Y4,   SHIFTU, X2Y10,  X2Y11,  X3Y11,
     - X3Y10,  X2Y10,  PENUP,  X6Y10,  X6Y11,  X5Y11,
     - X5Y10,  X6Y10,
*197  A*
     - X0Y0,   X0Y8,   X4Y12,  X8Y8,   X8Y0,   PENUP,
     - X0Y4,   X8Y4,   SHIFTU, X4Y10,  X5Y10,  X5Y11,
     - X4Y11,  X4Y10,
*198  AE
     - X0Y0,   X0Y8,   X2Y12,  X4Y8,   X4Y0,   X8Y0,
     - X4Y0,   X4Y12,  X8Y12,  PENUP,  X0Y6,   X8Y6,
*199  C,
     - X8Y2,   X6Y0,   X2Y0,   X0Y2,   X0Y10,  X2Y12,
     - X6Y12,  X8Y10,  SHIFTD, X3Y0,   X4Y1,   X4Y2/
      DATA (CHTAB(I), I=IP200,IP204-1)
*200  E`
     -/X8Y0,   X0Y0,   X0Y12,  X8Y12,  PENUP,  X0Y6,
     - X4Y6,   SHIFTU, X2Y12,  X6Y10,
*201  E'
     - X8Y0,   X0Y0,   X0Y12,  X8Y12,  PENUP,  X0Y6,
     - X4Y6,   SHIFTU, X2Y10,  X6Y12,
*202  E^
     - X8Y0,   X0Y0,   X0Y12,  X8Y12,  PENUP,  X0Y6,
     - X4Y6,   SHIFTU, X2Y10,  X4Y12,  X6Y10,
*203  E"
     - X8Y0,   X0Y0,   X0Y12,  X8Y12,  PENUP,  X0Y6,
     - X4Y6,   SHIFTU, X2Y10,  X2Y11,  X3Y11,  X3Y10,
     - X2Y10,  PENUP,  X6Y10,  X6Y11,  X5Y11,  X5Y10,
     - X6Y10/
      DATA (CHTAB(I), I=IP204,IP208-1)
*204  I`
     -/X2Y12,  X6Y12,  PENUP,  X4Y12,  X4Y0,   PENUP,
     - X2Y0,   X6Y0,   SHIFTU, X2Y12,  X6Y10,
*205  I'
     - X2Y12,  X6Y12,  PENUP,  X4Y12,  X4Y0,   PENUP,
     - X2Y0,   X6Y0,   SHIFTU, X2Y10,  X6Y12,
*206  I^
     - X2Y12,  X6Y12,  PENUP,  X4Y12,  X4Y0,   PENUP,
     - X2Y0,   X6Y0,   SHIFTU, X2Y10,  X4Y12,  X6Y10,
*207  I"
     - X2Y12,  X6Y12,  PENUP,  X4Y12,  X4Y0,   PENUP,
     - X2Y0,   X6Y0,   SHIFTU, X2Y10,  X2Y11,  X3Y11,
     - X3Y10,  X2Y10,  PENUP,  X6Y10,  X6Y11,  X5Y11,
     - X5Y10,  X6Y10/
      DATA (CHTAB(I), I=IP208,IP212-1)
*208  -D
     -/X2Y0,   X6Y0,   X8Y2,   X8Y8,   X6Y10,  X2Y10,
     - X2Y0,   PENUP,  X0Y5,   X4Y5,
*209  N~
     - X0Y0,   X0Y12,  X8Y0,   X8Y12,  SHIFTU, X2Y10,
     - X3Y11,  X5Y10,  X6Y11,
*210  O`
     - X2Y0,   X0Y2,   X0Y10,  X2Y12,  X6Y12,  X8Y10,
     - X8Y2,   X6Y0,   X2Y0,   SHIFTU, X2Y12,  X6Y10,
*211  O'
     - X2Y0,   X0Y2,   X0Y10,  X2Y12,  X6Y12,  X8Y10,
     - X8Y2,   X6Y0,   X2Y0,   SHIFTU, X2Y10,  X6Y12/
      DATA (CHTAB(I), I=IP212,IP216-1)
*212  O^
     -/X2Y0,   X0Y2,   X0Y10,  X2Y12,  X6Y12,  X8Y10,
     - X8Y2,   X6Y0,   X2Y0,   SHIFTU, X2Y10,  X4Y12,
     - X6Y10,
*213  O~
     - X2Y0,   X0Y2,   X0Y10,  X2Y12,  X6Y12,  X8Y10,
     - X8Y2,   X6Y0,   X2Y0,   SHIFTU, X2Y10,  X3Y11,
     - X5Y10,  X6Y11,
*214  O"
     - X2Y0,   X0Y2,   X0Y10,  X2Y12,  X6Y12,  X8Y10,
     - X8Y2,   X6Y0,   X2Y0,   SHIFTU, X2Y10,  X2Y11,
     - X3Y11,  X3Y10,  X2Y10,  PENUP,  X6Y10,  X6Y11,
     - X5Y11,  X5Y10,  X6Y10,
*215  x
     - X0Y2,   X8Y10,  PENUP,  X0Y10,  X8Y2/
      DATA (CHTAB(I), I=IP216,IP220-1)
*216  O/
     -/X2Y0,   X0Y2,   X0Y10,  X2Y12,  X6Y12,  X8Y10,
     - X8Y2,   X6Y0,   X2Y0,   PENUP,  X0Y0,   X8Y12,
*217  U`
     - X0Y12,  X0Y2,   X2Y0,   X6Y0,   X8Y2,   X8Y12,
     - SHIFTU, X2Y12,  X6Y10,
*218  U'
     - X0Y12,  X0Y2,   X2Y0,   X6Y0,   X8Y2,   X8Y12,
     - SHIFTU, X2Y10,  X6Y12,
*219  U^
     - X0Y12,  X0Y2,   X2Y0,   X6Y0,   X8Y2,   X8Y12,
     - SHIFTU, X2Y10,  X4Y12,  X6Y10/
      DATA (CHTAB(I), I=IP220,IP224-1)
*220  U"
     -/X0Y12,  X0Y2,   X2Y0,   X6Y0,   X8Y2,   X8Y12,
     - SHIFTU, X2Y10,  X2Y11,  X3Y11,  X3Y10,  X2Y10,
     - PENUP,  X6Y10,  X6Y11,  X5Y11,  X5Y10,  X6Y10,
*221  Y'
     - X0Y12,  X4Y6,   X8Y12,  PENUP,  X4Y6,   X4Y0,
     - SHIFTU, X2Y10,  X6Y12,
*222  TH
     - X0Y12,  X4Y12,  PENUP,  X2Y12,  X2Y0,   PENUP,
     - X0Y0,   X4Y0,   PENUP,  X2Y10,  X6Y10,  X8Y8,
     - X8Y6,   X6Y4,   X2Y4,
*223  ss
     - SHIFTD, X2Y2,   X2Y10,  X4Y12,  X6Y12,  X8Y10,
     - X6Y8,   X4Y8,   X6Y8,   X8Y6,   X6Y4,   X4Y4/
      DATA (CHTAB(I), I=IP224,IP228-1)
*224  a`
     -/X0Y7,   X1Y8,   X4Y8,   X6Y6,   X6Y0,   X8Y0,
     - X1Y0,   X0Y1,   X0Y3,   X1Y4,   X6Y4,   PENUP,
     - X2Y12,  X6Y10,
*225  a'
     - X0Y7,   X1Y8,   X4Y8,   X6Y6,   X6Y0,   X8Y0,
     - X1Y0,   X0Y1,   X0Y3,   X1Y4,   X6Y4,   PENUP,
     - X2Y10,  X6Y12,
*226  a^
     - X0Y7,   X1Y8,   X4Y8,   X6Y6,   X6Y0,   X8Y0,
     - X1Y0,   X0Y1,   X0Y3,   X1Y4,   X6Y4,   PENUP,
     - X2Y10,  X4Y12,  X6Y10,
*227  a~
     - X0Y7,   X1Y8,   X4Y8,   X6Y6,   X6Y0,   X8Y0,
     - X1Y0,   X0Y1,   X0Y3,   X1Y4,   X6Y4,   PENUP,
     - X2Y10,  X3Y11,  X5Y10,  X6Y11/
      DATA (CHTAB(I), I=IP228,IP232-1)
*228  a"
     -/X0Y7,   X1Y8,   X4Y8,   X6Y6,   X6Y0,   X8Y0,
     - X1Y0,   X0Y1,   X0Y3,   X1Y4,   X6Y4,   PENUP,
     - X2Y10,  X2Y11,  X3Y11,  X3Y10,  X2Y10,  PENUP,
     - X6Y10,  X6Y11,  X5Y11,  X5Y10,  X6Y10,
*229  a*
     - X0Y7,   X1Y8,   X4Y8,   X6Y6,   X6Y0,   X8Y0,
     - X1Y0,   X0Y1,   X0Y3,   X1Y4,   X6Y4,   PENUP,
     - X4Y10,  X5Y10,  X5Y11,  X4Y11,  X4Y10,
*230  ae
     - X0Y7,   X1Y8,   X3Y8,   X4Y7,   X4Y0,   X1Y0,
     - X0Y1,   X0Y3,   X1Y4,   X7Y4,   X8Y5,   X8Y7,
     - X7Y8,   X5Y8,   X4Y7,   X4Y2,   X6Y0,   X7Y0,
     - X8Y1,
*231  c,
     - SHIFTD, X8Y10,  X6Y12,  X2Y12,  X0Y10,  X0Y6,
     - X2Y4,   X6Y4,   X8Y6,   PENUP,  X3Y0,   X4Y1,
     - X4Y2/
      DATA (CHTAB(I), I=IP232,IP236-1)
*232  e`
     -/X8Y1,   X6Y0,   X2Y0,   X0Y2,   X0Y6,   X2Y8,
     - X6Y8,   X8Y6,   X7Y4,   X0Y4,   PENUP,  X2Y12,
     - X6Y10,
*233  e'
     - X8Y1,   X6Y0,   X2Y0,   X0Y2,   X0Y6,   X2Y8,
     - X6Y8,   X8Y6,   X7Y4,   X0Y4,   PENUP,  X2Y10,
     - X6Y12,
*234  e^
     - X8Y1,   X6Y0,   X2Y0,   X0Y2,   X0Y6,   X2Y8,
     - X6Y8,   X8Y6,   X6Y4,   X0Y4,   PENUP,  X2Y10,
     - X4Y12,  X6Y10,
*235  e"
     - X8Y1,   X6Y0,   X2Y0,   X0Y2,   X0Y6,   X2Y8,
     - X6Y8,   X8Y6,   X6Y4,   X0Y4,   PENUP,  X2Y10,
     - X2Y11,  X3Y11,  X3Y10,  X2Y10,  PENUP,  X6Y10,
     - X6Y11,  X5Y11,  X5Y10,  X6Y10/
      DATA (CHTAB(I), I=IP236,IP240-1)
*236  i`
     -/X3Y8,   X4Y8,   X4Y0,   X3Y0,   X5Y0,   PENUP,
     - PENUP,  X2Y12,  X6Y10,
*237  i'
     - X3Y8,   X4Y8,   X4Y0,   X3Y0,   X5Y0,   PENUP,
     - PENUP,  X2Y10,  X6Y12,
*238  i^
     - X3Y8,   X4Y8,   X4Y0,   X3Y0,   X5Y0,   PENUP,
     - X2Y10,  X4Y12,  X6Y10,
*239  i"
     - X3Y8,   X4Y8,   X4Y0,   X3Y0,   X5Y0,   PENUP,
     - X2Y10,  X2Y11,  X3Y11,  X3Y10,  X2Y10,  PENUP,
     - X6Y10,  X6Y11,  X5Y11,  X5Y10,  X6Y10/
      DATA (CHTAB(I), I=IP240,IP244-1)
*240  -d
     -/X0Y12,  X8Y4,   X8Y2,   X6Y0,   X4Y0,   X2Y2,
     - X2Y4,   X4Y6,   X6Y6,   PENUP,  X0Y6,   X4Y10,
*241  n~
     - X0Y0,   X0Y8,   PENUP,  X0Y6,   X2Y8,   X6Y8,
     - X8Y6,   X8Y0,   PENUP,  X2Y10,  X3Y11,  X5Y10,
     - X6Y11,
*242  o`
     - X0Y2,   X0Y6,   X2Y8,   X6Y8,   X8Y6,   X8Y2,
     - X6Y0,   X2Y0,   X0Y2,   PENUP,  X2Y12,  X6Y10,
*243  o'
     - X0Y2,   X0Y6,   X2Y8,   X6Y8,   X8Y6,   X8Y2,
     - X6Y0,   X2Y0,   X0Y2,   PENUP,  X2Y10,  X6Y12/
      DATA (CHTAB(I), I=IP244,IP248-1)
*244  o^
     -/X0Y2,   X0Y6,   X2Y8,   X6Y8,   X8Y6,   X8Y2,
     - X6Y0,   X2Y0,   X0Y2,   PENUP,  X2Y10,  X4Y12,
     - X6Y10,
*245  o~
     - X0Y2,   X0Y6,   X2Y8,   X6Y8,   X8Y6,   X8Y2,
     - X6Y0,   X2Y0,   X0Y2,   PENUP,  X2Y10,  X3Y11,
     - X5Y10,  X6Y11,
*246  o"
     - X0Y2,   X0Y6,   X2Y8,   X6Y8,   X8Y6,   X8Y2,
     - X6Y0,   X2Y0,   X0Y2,   PENUP,  X2Y10,  X2Y11,
     - X3Y11,  X3Y10,  X2Y10,  PENUP,  X6Y10,  X6Y11,
     - X5Y11,  X5Y10,  X6Y10,
*247  -:
     - X0Y6,   X8Y6,   PENUP,  X4Y8,   X4Y9,   X5Y9,
     - X5Y8,   X4Y8,   PENUP,  X4Y4,   X4Y3,   X5Y3,
     - X5Y4,   X4Y4/
      DATA (CHTAB(I), I=IP248,IP252-1)
*248  o/
     -/X0Y2,   X0Y6,   X2Y8,   X6Y8,   X8Y6,   X8Y2,
     - X6Y0,   X2Y0,   X0Y2,   PENUP,  X0Y0,   X8Y8,
*249  u`
     - X0Y8,   X0Y2,   X2Y0,   X6Y0,   X8Y2,   X8Y8,
     - X8Y0,   PENUP,  X2Y12,  X6Y10,
*250  u'
     - X0Y8,   X0Y2,   X2Y0,   X6Y0,   X8Y2,   X8Y8,
     - X8Y0,   PENUP,  X2Y10,  X6Y12,
*251  u^
     - X0Y8,   X0Y2,   X2Y0,   X6Y0,   X8Y2,   X8Y8,
     - X8Y0,   PENUP,  X2Y10,  X4Y12,  X6Y10/
      DATA (CHTAB(I), I=IP252,IP256-1)
*252  u"
     -/X0Y8,   X0Y2,   X2Y0,   X6Y0,   X8Y2,   X8Y8,
     - X8Y0,   PENUP,  X2Y10,  X2Y11,  X3Y11,  X3Y10,
     - X2Y10,  PENUP,  X6Y10,  X6Y11,  X5Y11,  X5Y10,
     - X6Y10,
*253  y'
     - SHIFTD, X0Y12,  X0Y6,   X2Y4,   X6Y4,   X8Y6,
     - X8Y12,  X8Y2,   X6Y0,   X2Y0,   SHIFTU, X2Y10,
     - X6Y12,
*254  -d
     - X2Y0,   X6Y0,   X8Y2,   X8Y4,   X6Y6,   X2Y6,
     - SHIFTD, X2Y12,  X2Y0,
*255  y"
     - SHIFTD, X0Y12,  X0Y6,   X2Y4,   X6Y4,   X8Y6,
     - X8Y12,  X8Y2,   X6Y0,   X2Y0,   SHIFTU, X2Y10,
     - X2Y11,  X3Y11,  X3Y10,  X2Y10,  PENUP,  X6Y10,
     - X6Y11,  X5Y11,  X5Y10,  X6Y10/


* Get a pointer to the coordinate table
* Plot the character
      IC=ICHAR(CHAR)
      IF (IC.LT.0) IC=IC+256
      IT=IPT(IC)
      NB=IPT(IC+1)-IT
      CALL DRCHAR(IX0,IY0,CHTAB(IT),NB)


      RETURN

      END
