*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     INTEGER FUNCTION IPOSN (MINX, MINY, MAXX, MAXY, IX, IY)
*
*
* Purpose:
*     Return a location code relative to a rectangle
*
*
* Description:
*     The returned function value is coded as the sum of the following
*     codes.
*       0 - The point is within the rectangle
*       1 - The point is to the Left of the rectangle
*       2 - The point is to the Right of the rectangle
*       4 - The point is Below the rectangle
*       8 - The point is Above the rectangle
*
*
* Parameters:
* I <-  IPOSN  - Returned function value, giving the relative position
*                of the test point with respect to the given rectangle.
*                Note that codes 3 and 7 are never returned.
*                1 - Left                6 - Right and Bottom
*                2 - Right               8 - Top
*                4 - Bottom              9 - Left and Top
*                5 - Left and Bottom    10 - Right and Top
*
* I ->  MINX,MINY - X and Y coordinates or the lower lefthand corner
*                   of the visible rectangle (plotting coordinates)
* I ->  MAXX,MAXY - X and Y coordinates of the upper righthand corner
*                   of the visible rectangle (plotting coordinates)
* I ->  IX,IY     - X and Y coordinates of the point to be tested
*                   (plotting coordinates)
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.5 $  $Date: 1995/03/08 15:30:47 $
*
*
*-----------------------------------------------------------------------

      INTEGER FUNCTION IPOSN (MINX, MINY, MAXX, MAXY, IX, IY)


      INTEGER IL,IR,IB,IT
      PARAMETER (IL=1,IR=2,IB=4,IT=8)

      INTEGER MINX,MINY,MAXX,MAXY,IX,IY

      IPOSN=0

      IF (IX.LT.MINX) THEN
        IPOSN=IL
      ELSE IF (IX.GT.MAXX) THEN
        IPOSN=IR
      END IF

      IF (IY.LT.MINY) THEN
        IPOSN=IPOSN+IB
      ELSE IF (IY.GT.MAXY) THEN
        IPOSN=IPOSN+IT
      END IF


      RETURN

      END
