*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE GETPOS (IX, IY)
*     SUBROUTINE SETPOS (IX, IY)
*
*
* Purpose:
*     Get the current plot position
*     Set the plot position
*
*
* Description:
*     This subroutine gets or sets the coordinates of the current plot
*     position.  The SETPOS routine should not normally be used by the
*     end user.  The plot position is automatically changed by the
*     plotting routines.
*
*
* Parameters:
*     Subroutine GETPOS
* I <-  IX     - X coordinate of the current plot position
* I <-  IY     - Y coordinate of the current plot position
*
*     Subroutine SETPOS
* I ->  IX     - X coordinate of the current plot position
* I ->  IY     - Y coordinate of the current plot position
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:30:44 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE GETPOS (IX, IY)


      INTEGER IX,IY
      INTEGER IX0,IY0

      SAVE IX0,IY0

      DATA IX0,IY0/0,0/


* Return the current plot position
      IX=IX0
      IY=IY0

      GO TO 900

*----------
* Set the position
      ENTRY SETPOS (IX, IY)


      IX0=IX
      IY0=IY


 900  RETURN

      END
