*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE DRCHAR (IX0, IY0, CHTAB, NB)
*
*
* Purpose:
*     Draw a character
*
*
* Description:
*     The given character is plotted at the given plotting coordinates.
*     Characters are defined on a 10 by 14 grid.  However, many
*     characters use only the even valued grid points, resulting in an
*     effective 5 by 7 point grid for the characters.  Characters are
*     drawn by joining points on the grid.
*
*     Each point is stored as an X-Y pair in a byte, 4 bits for each
*     coordinate.  In addition special byte values define codes which
*     specify pen up and coordinate shifts.
*
*     The character size and orientation are stored as integer valued
*     X and Y increments for each of the width and height directions in
*     the character grid.  Subroutine SETCHR can be used to change the
*     character size and orientation.  The initial character size is
*     32 plotting units wide and 48 plotting units high.
*
*
* Parameters:
* I ->  IX0    - X coordinate of the corner of the character (lower
*                left hand corner for characters plotted parallel to
*                the X direction)
* I ->  IY0    - Y coordinate of the corner of the character (lower
*                left hand corner for characters plotted parallel to
*                the X direction)
* B ->  CHTAB  - Array of bytes storing the coordinates
* I ->  NB     - Number of bytes in CHTAB
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.5 $  $Date: 1995/03/08 15:30:41 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE DRCHAR (IX0, IY0, CHTAB, NB)


      INTEGER IASP,IBUP,IBSD,IBSU
      INTEGER IUP,IDOWN
      PARAMETER (IASP=15,IBUP=0,IBSD=1,IBSU=2)
      PARAMETER (IUP=0,IDOWN=1)

      INTEGER IX0,IY0,NB
      INTEGER IW,IH,IPEN,IBOFFS,I,IT,IA,IB,IXR,IYR

      BYTE CHTAB(*)

      REAL ANG,XC,YC


* Initialization
      CALL GETCHR(IW,IH,ANG)
      IPEN=IUP
      IBOFFS=0

* The coordinates are stored as an X-Y pair in bytes.  IA and IB
* represent the values of the X and Y values respectively.  IA
* equal to IASP signals a special action.  The special actions are:
*   PENUP  - Lift the pen.  Plotting commences with the next
*            coordinate.
*   SHIFTD - The Y coordinate is shifted down 4 grid units.  The pen is
*            also lifted.  This command can be used to plot characters
*            with descenders.
*   SHIFTU - The Y coordinate is shifted up 4 grid units.  The pen is
*            also lifted.
* There is an implicit UP command at the beginning of each character.
* The plotting pen is moved to the first coordinate after an UP
* command and plotting commences from that point.

* Drawing loop - pick up an X-Y coordinate
      DO 100 I=1,NB
        IT=CHTAB(I)
        IA=(IT.AND.255)/16
        IB=(IT.AND.15)

        IF (IA.NE.IASP) THEN

* Drawing routine
          XC=IW*IA/8.
          YC=IH*(IB+IBOFFS)/12.
          CALL ROTPTC(XC,YC,ANG,IXR,IYR)
          IF (IPEN.EQ.IDOWN) THEN
            CALL XYDRAW(IX0+IXR,IY0+IYR)
          ELSE
            CALL XYMOVE(IX0+IXR,IY0+IYR)
            IPEN=IDOWN
          END IF

        ELSE

* Special action, decode
          IF (IB.EQ.IBUP) THEN
            IPEN=IUP
          ELSE IF (IB.EQ.IBSD) THEN
            IBOFFS=IBOFFS-4
            IPEN=IUP
          ELSE
            IBOFFS=IBOFFS+4
            IPEN=IUP
          END IF

        END IF

 100  CONTINUE


      RETURN

      END
