*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE DECXAX (LINE, IXAX, ATICK, NTICK, ALABEL, NLABEL)
*
*
* Purpose:
*     Decode X-axis plot options
*
*
* Description:
*     An option string containing a number of option specifications is
*     decoded.  Individual option specifications are separated by white
*     space (blanks, tabs or null characters) or commas.  The general
*     form of the option specifications is KEYWORD=arg or KEYWORD, where
*     KEYWORD is a keyword string.  Keywords can be specified in upper or
*     lower case and in most cases allow for short forms.  The argument
*     string following the keyword is used to specify values or subsidiary
*     option specifications.  Within the argument string, parentheses are
*     used to group lists of values or subsidiary option specifications.
*     Lists of values are enclosed in parentheses with the values
*     separated by white space or commas.  The same keyword may be given
*     more than once, with the last invokation taking precedence.
*
*     The subroutine parameters are shown below along with the
*     corresponding specification in the option string.  The values
*     of the subroutine parameters are changed only if the corresponding
*     keyword is present.
*
*
* Parameters:
* C <-> LINE   - Input character string.  The string is set to blanks
*                on return.
* I <-  IXAX   - Four element integer array specifying the axis options
*                IXAX(0) = ILL + 4*IUL + 16*ITICK + 32*ILABEL + 64*ILOG
*                  ILL   -  1  LIMITS=TICKS or
*                              LIMITS=(LOWER_LIMIT=TICK)
*                           2  LIMITS=EXACT or
*                              LIMITS=(LOWER_LIMIT=EXACT)
*                  IUL   -  0  (default)
*                           1  LIMITS=TICKS or
*                              LIMITS=(UPPER_LIMIT=TICK)
*                           2  LIMITS=EXACT or
*                              LIMITS=(UPPER_LIMIT=EXACT)
*                  ITICK  - 0  TICKS
*                           1  TICKS=(...)
*                  ILABEL - 0  LABELS
*                           1  LABELS=(...)
*                  ILOG   - 0  LINEAR
*                           1  LOGARITHMIC
*                IXAX(1) - 0  BOTTOM=OFF
*                          1  BOTTOM=LINE
*                          2  BOTTOM=ON
*                          3  BOTTOM=LABELLED
*                IXAX(2) - 0  ORIGIN=OFF
*                          1  ORIGIN=LINE
*                          2  ORIGIN=ON
*                          3  ORIGIN=LABELLED
*                IXAX(3) - 0  TOP=OFF
*                          1  TOP=LINE
*                          2  TOP=ON
*                          3  TOP=LABELLED
* R <-  ATICK  - Array of NTICK tick values
*                TICKS=(val1 val2 ...)
* I <-  NTICK  - Number of elements defined in ATICK.  NTICK is at most
*                100.
*                TICKS=(val1 val2 ...)
* C <-  ALABEL - Character array with NLABEL elements. A null character
*                terminates short strings.
*                LABELS=("label1" "label2" ...)
* I <-  NLABEL - Number of elements defined in ALABEL.  NLABEL is at
*                most 100.
*                LABELS=(label1 label2 ...)
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:30:35 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE DECXAX (LINE, IXAX, ATICK, NTICK, ALABEL, NLABEL)


      INTEGER OFF,ON,LABEL,NOTDEF,DEF,LINS,LOGS
      INTEGER MXTICK
      PARAMETER (OFF=0,ON=2,LABEL=3,NOTDEF=0,DEF=1,LINS=0,LOGS=1)
      PARAMETER (MXTICK=100)

      INTEGER NTICK
      INTEGER IXAX(0:3)
      INTEGER IFN,ILL,IUL,ITICK,ILABEL,ILOG,
     -        NCT,N,INDEX,NN,NLABEL
      INTEGER LENSTR

      CHARACTER*(*) LINE,ALABEL(*)
      CHARACTER*512 TOKEN

      REAL ATICK(*)

      INTEGER NEXAX,NEAXT
      PARAMETER (NEXAX=10)
      CHARACTER*12 XAXTAB(NEXAX)
      PARAMETER (NEAXT=4)
      CHARACTER*9 AXTTAB(NEAXT)

      DATA IFN/0/
      DATA XAXTAB/'LIM*ITS'        , 'BOT*TOM'        ,
     -            'ORIG*IN'        , 'TOP'            ,
     -            'TICK*S'         , 'LABEL*S'        ,
     -            'ON'             , 'OFF'            ,
     -            'LIN*EAR'        , 'LOG*ARITHMIC'   /
      DATA AXTTAB/'OFF'            , 'LINE'           ,
     -            '*ON'            , 'LABEL*LED'      /


* Separate the elements of the axis option code
      ILL=MOD(IXAX(0),4)
      IUL=MOD(IXAX(0)/4,4)
      ITICK=MOD(IXAX(0)/16,2)
      ILABEL=MOD(IXAX(0)/32,2)
      ILOG=MOD(IXAX(0)/64,2)


 100  IF (LENSTR(LINE).GT.0) THEN
        CALL FNDPAR(LINE,XAXTAB,NEXAX,TOKEN,NCT,N)

*** LIMITS
        IF (N.EQ.1) THEN
          CALL DECAXL(TOKEN,ILL,IUL)

*** BOTTOM =, ORIGIN = or TOP =
        ELSE IF (N.EQ.2 .OR. N.EQ.3 .OR. N.EQ.4) THEN
          INDEX=N-1
          CALL FNDPAR(TOKEN,AXTTAB,NEAXT,TOKEN(1:IFN),NCT,NN)
          IF (NN.GT.0) IXAX(INDEX)=NN-1

*** TICKS =
        ELSE IF (N.EQ.5) THEN
          CALL RDRVAL(TOKEN,0,MXTICK,ATICK,NTICK)
          IF (NTICK.EQ.0) THEN
            ITICK=NOTDEF
          ELSE
            ITICK=DEF
          END IF

*** LABELS =
        ELSE IF (N.EQ.6) THEN
          CALL RDCSTR(TOKEN,0,MXTICK,ALABEL,NLABEL)
          IF (NLABEL.EQ.0) THEN
            ILABEL=NOTDEF
          ELSE
            ILABEL=DEF
          END IF

*** ON
        ELSE IF (N.EQ.7) THEN
          IXAX(1)=LABEL
          IXAX(2)=ON
          IXAX(3)=ON

*** OFF
        ELSE IF (N.EQ.8) THEN
          IXAX(1)=OFF
          IXAX(2)=OFF
          IXAX(3)=OFF

*** LINEAR
        ELSE IF (N.EQ.9) THEN
          ILOG=LINS

*** LOGARITHMIC
        ELSE IF (N.EQ.10) THEN
          ILOG=LOGS

***
        END IF

      GO TO 100
      END IF

* Form the composite axis option code
      IXAX(0)=ILL+4*IUL+16*ITICK+32*ILABEL+64*ILOG


      RETURN

      END
