*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE DECPLT (OPTION, ICCSIZE, LINTYP, IPATTN,
*                        SYMBOL, ISSIZE, SANG,
*                        IXAX, IYAX, IXORIG, IYORIG, LENX, LENY,
*                        ATICKX, ATICKY, ALABLX, ALABLY,
*                        NTICKX, NTICKY)
*
*
* Purpose:
*     Decode a plot option string
*
*
* Description:
*     An option string containing a number of option specifications is
*     decoded.  Individual option specifications are separated by white
*     space (blanks, tabs or null characters) or commas.  The general
*     form of the option specifications is KEYWORD=arg or KEYWORD, where
*     KEYWORD is a keyword string.  Keywords can be specified in upper or
*     lower case and in most cases allow for short forms.  The argument
*     string following the keyword is used to specify values or subsidiary
*     option specifications.  Within the argument string, parentheses are
*     used to group lists of values or subsidiary option specifications.
*     Lists of values are enclosed in parentheses with the values
*     separated by white space or commas.  The same keyword may be given
*     more than once, with the last invokation taking precedence.
*
*     Default options are used if some or all of the keywords are
*     omitted.  The subroutine parameters are shown below along with the
*     corresponding specification in the option string.
*
*
* Parameters:
* C ->  OPTION - Input character string
* I <-  ICSIZE - Two element array specifying the character size
*                CHARACTER_SIZE = (width height) (default (32 48))
* I <-  LINTYP - 1  LINE-TYPE=POINTS
*                2  LINE-TYPE=LINE (default)
*                3  LINE-TYPE=LINE+POINTS
*                4  LINE-TYPE=SMOOTH
*                5  LINE-TYPE=SMOOTH+POINTS
* I <-  IPATTN - Five element integer array
*                LINE-TYPE=(PATTERN=(xx yy ...)) (default all zeros)
* C <-  SYMBOL - Character string specifying the plot symbols
*                LINE-TYPE=(SYMBOLS="xxxxx") (default CHAR(161)//
*                CHAR(162)//...)
* I <-  ISSIZE - Two element array specifying the symbol size
*                LINE-TYPE=(SYMBOL_SIZE=(width height)) (default
*                from ICSIZE)
* R <-  SANG   - Real value specifying the symbol angle
*                LINE-TYPE=(SYMBOL_ANGLE=angle) (default 0.0)
* I <-  IXAX   - Four element integer array,
*                X-AXIS=option
*                IXAX(0) = ILL + 4*IUL + 16*ITICK + 32*ILABEL + 64*ILOG
*                  ILL   -  0  (default)
*                           1  X-AXIS=(LIMITS=TICKS) or
*                              X-AXIS=(LIMITS=(LOWER_LIMIT=TICK))
*                           2  X-AXIS=(LIMITS=EXACT) or
*                              X-AXIS=(LIMITS=(LOWER_LIMIT=EXACT))
*                  IUL   -  0  (default)
*                           1  X-AXIS=(LIMITS=TICKS) or
*                              X-AXIS=(LIMITS=(UPPER_LIMIT=TICK))
*                           2  X-AXIS=(LIMITS=EXACT) or
*                              X-AXIS=(LIMITS=(UPPER_LIMIT=EXACT))
*                  ITICK  - 0  X-AXIS=TICKS (default)
*                           1  X-AXIS=(TICKS=(...))
*                  ILABEL - 0  X-AXIS=LABELS (default)
*                           1  X-AXIS=(LABELS=(...))
*                  ILOG   - 0  X-AXIS=LINEAR (default)
*                           1  X-AXIS=LOGARITHMIC
*                IXAX(1) - 0  X-AXIS=(BOTTOM=OFF)
*                          1  X-AXIS=(BOTTOM=LINE)
*                          2  X-AXIS=(BOTTOM=ON)
*                          3  X-AXIS=(BOTTOM=LABELLED) (default)
*                IXAX(2) - 0  X-AXIS=(ORIGIN=OFF)
*                          1  X-AXIS=(ORIGIN=LINE)
*                          2  X-AXIS=(ORIGIN=ON) (default)
*                          3  X-AXIS=(ORIGIN=LABELLED)
*                        Note: IXAX(2)=0 for a log X-axis.
*                IXAX(3) - 0  X-AXIS=(TOP=OFF)
*                          1  X-AXIS=(TOP=LINE)
*                          2  X-AXIS=(TOP=ON) (default)
*                          3  X-AXIS=(TOP=LABELLED)
* I <-  IYAX   - Four element integer array,
*                Y-AXIS=option
*                IXAX(0) = ILL + 4*IUL + 16*ITICK + 32*ILABEL + 64*ILOG
*                  ILL    - 0  (default)
*                           1  Y-AXIS=(LIMITS=TICKS) or
*                              Y-AXIS=(LIMITS=(LOWER_LIMIT=TICK))
*                           2  Y-AXIS=(LIMITS=EXACT) or
*                              Y-AXIS=(LIMITS=(LOWER_LIMIT=EXACT))
*                  IUL    - 0  (default)
*                           1  Y-AXIS=(LIMITS=TICKS) or
*                              Y-AXIS=(LIMITS=(UPPER_LIMIT=TICK))
*                           2  Y-AXIS=(LIMITS=EXACT) or
*                              Y-AXIS=(LIMITS=(UPPER_LIMIT=EXACT))
*                  ITICK  - 0  Y-AXIS=TICKS (default)
*                           1  Y-AXIS=(TICKS=(...))
*                  ILABEL - 0  Y-AXIS=LABELS (default)
*                           1  Y-AXIS=(LABELS=(...))
*                  ILOG   - 0  Y-AXIS=LINEAR (default)
*                           1  Y-AXIS=LOGARITHMIC
*                IYAX(1) - 0  Y-AXIS=(LEFT=OFF)
*                          1  Y-AXIS=(LEFT=LINE)
*                          2  Y-AXIS=(LEFT=ON)
*                          3  Y-AXIS=(LEFT=LABELLED) (default)
*                IYAX(2) - 0  Y-AXIS=(ORIGIN=OFF)
*                          1  Y-AXIS=(ORIGIN=LINE)
*                          2  Y-AXIS=(ORIGIN=ON) (default)
*                          3  Y-AXIS=(ORIGIN=LABELLED)
*                        Note: IYAX(2)=0 for a log Y-axis.
*                IYAX(3) - 0  Y-AXIS=(RIGHT=OFF)
*                          1  Y-AXIS=(RIGHT=LINE)
*                          2  Y-AXIS=(RIGHT=ON) (default)
*                          3  Y-AXIS=(RIGHT=LABELLED)
* I <-  IXORIG - X-coordinate of the plot position
*                POSITION=(IX IY) (default 720)
* I <-  IYORIG - Y-coordinate of the plot position
*                POSITION=(IX IY) (default 440)
* I <-  LENX   - X-dimension of the plot size
*                SIZE=(Lenx Leny) (default 3240)
* I <-  LENY   - Y-dimension of the plot size
*                SIZE=(Lenx Leny) (default 2400)
* R <-  ATICKX - Array of NTICKX tick values.
*                X-AXIS=(TICKS=(val1 val2 ...))
* R <-  ATICKY - Array of NTICKY tick values.
*                Y-AXIS=(TICKS=(val1 val2 ...))
* C <-  ALABLX - Character array with NTICKX elements. A null character
*                terminates short strings.
*                X-AXIS=(LABELS=("label1" "label2" ...)) (default, all
*                labels of zero length)
* C <-  ALABLY - Character array with NTICKY elements. A null character
*                terminates short strings.
*                Y-AXIS=(LABELS=("label1" "label2" ...)) (default, all
*                labels of zero length)
* I <-  NTICKX - Number of elements defined in ATICKX.  NTICKX is at
*                most 100.
*                X-AXIS=(TICKS=(val1 val2 ...)) (default 0)
* I <-  NTICXY - Number of elements defined in ATICKY.  NTICKY is at
*                most 100.
*                Y-AXIS=(TICKS=(val1 val2 ...)) (default 0)
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:30:32 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE DECPLT (OPTION, ICSIZE, LINTYP, IPATTN,
     -                   SYMBOL, ISSIZE, SANG,
     -                   IXAX, IYAX, IXORIG, IYORIG, LENX, LENY,
     -                   ATICKX, ATICKY, ALABLX, ALABLY,
     -                   NTICKX, NTICKY)


      INTEGER DEFAULT,TICKV,EXACTV,OFF,LINES,ON,LABEL,
     -        NOTDEF,DEF,LINS,LOGS
      PARAMETER (DEFAULT=0,TICKV=1,EXACTV=2,OFF=0,
     -           LINES=2,ON=2,LABEL=3,
     -           NOTDEF=0,DEF=1,LINS=0,LOGS=1)

      INTEGER LINTYP,NTICKX,NTICKY
      INTEGER ILL,IUL,ITICK,ILABEL,ILOG,IXORIG,IYORIG,LENX,LENY,
     -        NLABLX,NLABLY,NCL,NCT,N,NV,IER,I
      INTEGER IPATTN(5),ICSIZE(2),ISSIZE(2),
     -        IXAX(0:3),IYAX(0:3)
      INTEGER LENSTR

      REAL ATICKX(*),ATICKY(*)
      REAL SANG

      CHARACTER*(*) OPTION,SYMBOL,ALABLX(*),ALABLY(*)
      CHARACTER*2048 LINE
      CHARACTER*512 TOKEN

      INTEGER NEKEY
      PARAMETER (NEKEY=6)
      CHARACTER*15 KEYTAB(NEKEY)
      DATA KEYTAB/'CHAR*ACTER_SIZE', 'LINE*-TYPE'     ,
     -            'X-AX*IS'        , 'Y-AX*IS'        ,
     -            'POS*ITION'      , 'SIZE'           /


* Default values
      LINTYP=LINES
      CALL IZERO(IPATTN,5)
      SYMBOL=CHAR(161)//CHAR(162)//CHAR(163)//CHAR(164)//
     -       CHAR(165)//CHAR(166)//CHAR(167)//CHAR(168)//
     -       CHAR(169)//CHAR(170)//CHAR(0)

      ICSIZE(1)=32
      ICSIZE(2)=48
      ISSIZE(1)=-1
      ISSIZE(2)=-1
      SANG=0.0

      ILL=DEFAULT
      IUL=DEFAULT
      ITICK=NOTDEF
      ILABEL=NOTDEF
      ILOG=LINS
      IXAX(0)=ILL+4*IUL+16*ITICK+32*ILABEL+64*ILOG
      IXAX(1)=LABEL
      IXAX(2)=ON
      IXAX(3)=ON

      IYAX(0)=IXAX(0)
      IYAX(1)=IXAX(1)
      IYAX(2)=IXAX(2)
      IYAX(3)=IXAX(3)

      IXORIG=720
      IYORIG=440
      LENX=3240
      LENY=2400
      NTICKX=0
      NTICKY=0
      NLABLX=0
      NLABLY=0

      CALL RQUOTE(OPTION,LINE,NCL)

* Decode options
 100  NCL=LENSTR(LINE(1:NCL))
      IF (NCL.GT.0) THEN
        CALL FNDPAR(LINE,KEYTAB,NEKEY,TOKEN,NCT,N)

*** CHARACTER_SIZE =
        IF (N.EQ.1) THEN
          CALL RDIVAL(TOKEN(1:NCT),2,2,ICSIZE,NV)

*** LINE-TYPE =
        ELSE IF (N.EQ.2) THEN
          CALL DECLIN(TOKEN(1:NCT),LINTYP,IPATTN,SYMBOL,ISSIZE,SANG)

*** X-AXIS =
        ELSE IF (N.EQ.3) THEN
          CALL DECXAX(TOKEN(1:NCT),IXAX,ATICKX,NTICKX,ALABLX,NLABLX)

*** Y-AXIS =
        ELSE IF (N.EQ.4) THEN
          CALL DECYAX(TOKEN(1:NCT),IYAX,ATICKY,NTICKY,ALABLY,NLABLY)

*** POSITION =
        ELSE IF (N.EQ.5) THEN
          CALL RDIVA2(TOKEN(1:NCT),IXORIG,IYORIG,IER)

*** SIZE =
        ELSE IF (N.EQ.6) THEN
          CALL RDIVA2(TOKEN(1:NCT),LENX,LENY,IER)

***
        END IF

      GO TO 100
      END IF

* Set the default symbol size
      IF (ISSIZE(1).EQ.-1 .AND. ISSIZE(2).EQ.-1) THEN
        ISSIZE(1)=ICSIZE(1)
        ISSIZE(2)=ICSIZE(2)
      END IF

* Define unspecified labels as nulls
      DO 220 I=NLABLX+1,NTICKX
        ALABLX(I)=CHAR(0)
 220  CONTINUE
      DO 240 I=NLABLY+1,NTICKY
        ALABLY(I)=CHAR(0)
 240  CONTINUE

* Turn off origin axes for log plots
      ILOG=MOD(IXAX(0)/64,2)
      IF (ILOG.NE.0) IYAX(2)=OFF
      ILOG=MOD(IYAX(0)/64,2)
      IF (ILOG.NE.0) IXAX(2)=OFF


      RETURN

      END
