*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE DECLIN (LINE, LINTYP, IPATTN, SYMBOL, ISSIZE, SANG)
*
*
* Purpose:
*     Decode line-type plot options
*
*
* Description:
*     An option string containing a number of option specifications is
*     decoded.  Individual option specifications are separated by white
*     space (blanks, tabs or null characters) or commas.  The general
*     form of the option specifications is KEYWORD=arg or KEYWORD, where
*     KEYWORD is a keyword string.  Keywords can be specified in upper or
*     lower case and in most cases allow for short forms.  The argument
*     string following the keyword is used to specify values or subsidiary
*     option specifications.  Within the argument string, parentheses are
*     used to group lists of values or subsidiary option specifications.
*     Lists of values are enclosed in parentheses with the values
*     separated by white space or commas.  The same keyword may be given
*     more than once, with the last invokation taking precedence.
*
*     The subroutine parameters are shown below along with the
*     corresponding specification in the option string.  The values
*     of the subroutine parameters are changed only if the corresponding
*     keyword is present.
*
*
* Parameters:
* C <-> LINE   - Input character string.  The string is set to blanks
*                on return.
* I <-  LINTYP - Integer line type code
*                1  POINTS
*                2  LINE
*                3  LINE+POINTS
*                4  SMOOTH
*                5  SMOOTH+POINTS
* I <-  IPATTN - Five element integer array specifying the line pattern
*                PATTERN=(xx yy ...)
* C <-  SYMBOL - Character string specifying the plot symbols
*                SYMBOLS="xxxxx"
* I <-  ISSIZE - Two element array specifying the symbol size
*                SYMBOL_SIZE=(width height)
* R <-  SANG   - Real value specifying the symbol plotting angle
*                SYMBOL_ANGLE=angle
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.5 $  $Date: 1995/03/08 15:30:29 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE DECLIN (LINE, LINTYP, IPATTN, SYMBOL, ISSIZE, SANG)


      INTEGER LINTYP
      INTEGER IPATTN(5),ISSIZE(2)
      INTEGER NCT,N,NC,IER
      INTEGER LENSTR

      REAL SANG

      CHARACTER*(*) LINE,SYMBOL
      CHARACTER*512 TOKEN

      INTEGER NEKEY
      PARAMETER (NEKEY=9)
      CHARACTER*(14) KEYTAB(NEKEY)
      DATA KEYTAB/'POINT*S'        , 'LINE'           ,
     -            'LINE+*POINTS'   , 'SMOOTH'         ,
     -            'SMOOTH+*POINTS' , 'SYM*BOLS'       ,
     -            'SYMBOL_SIZE'    , 'SYMBOL_ANGLE'   ,
     -            'PATTERN'        /


 100  IF (LENSTR(LINE).GT.0) THEN
        CALL FNDPAR(LINE,KEYTAB,NEKEY,TOKEN,NCT,N)

*** POINTS, LINE, LINE+POINTS, SMOOTH, ...
        IF (N.GE.1 .AND. N.LE.5) THEN
          LINTYP=N

*** SYMBOL =
        ELSE IF (N.EQ.6) THEN
          CALL RQUOTE(TOKEN,SYMBOL,NC)
          IF (NC.LT.LEN(SYMBOL)) SYMBOL(NC+1:)=CHAR(0)

*** SYMBOL_SIZE =
        ELSE IF (N.EQ.7) THEN
          CALL RDIVAL(TOKEN,2,2,ISSIZE,N)

*** SYMBOL_ANGLE =
        ELSE IF (N.EQ.8) THEN
          CALL RDRVA1(TOKEN,SANG,IER)

*** PATTERN =
        ELSE IF (N.EQ.9) THEN
          CALL RDIVAL(TOKEN,1,5,IPATTN,N)
          IF (N.LT.5) CALL IZERO(IPATTN(N+1),5-N)

***
        END IF

      GO TO 100
      END IF


      RETURN

      END
