*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE DECAXL (LINE, ILL, IUL)
*
*
* Purpose:
*     Decode axis limit plot options
*
*
* Description:
*     An option string containing a number of option specifications is
*     decoded.  Individual option specifications are separated by white
*     space (blanks, tabs or null characters) or commas.  The general
*     form of the option specifications is KEYWORD=arg or KEYWORD, where
*     KEYWORD is a keyword string.  Keywords can be specified in upper or
*     lower case and in most cases allow for short forms.  The argument
*     string following the keyword is used to specify values or subsidiary
*     option specifications.  Within the argument string, parentheses are
*     used to group lists of values or subsidiary option specifications.
*     Lists of values are enclosed in parentheses with the values
*     separated by white space or commas.  The same keyword may be given
*     more than once, with the last invokation taking precedence.
*
*     The subroutine parameters are shown below along with the
*     corresponding specification in the option string.  The values of
*     the subroutine parameters are changed only if the corresponding
*     keyword is present.
*
*
* Parameters:
* C <-> LINE   - Input character string.  The string is set to blanks
*                on return.
* I <-  ILL    - Lower limit option
*                1  TICKS or
*                   (LOWER_LIMIT=TICK)
*                2  EXACT or
*                   (LOWER_LIMIT=EXACT)
* I <-  IUL    - Upper limit option
*                the corresponding keyword is present.
*                1  TICKS or
*                   (UPPER_LIMIT=TICK)
*                2  EXACT or
*                   (UPPER_LIMIT=EXACT)
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:30:25 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE DECAXL (LINE, ILL, IUL)


      INTEGER TICKV,EXACTV
      PARAMETER (TICKV=1,EXACTV=2)

      INTEGER ILL,IUL
      INTEGER IFN,NCT,N,NN
      INTEGER LENSTR

      CHARACTER*(*) LINE
      CHARACTER*512 TOKEN

      INTEGER NELIM,NESLM
      PARAMETER (NELIM=4)
      CHARACTER*12 LIMTAB(NELIM)
      PARAMETER (NESLM=2)
      CHARACTER*5 SLMTAB(NESLM)


      DATA IFN/0/
      DATA LIMTAB/'TICK*S'         , 'EXACT'          ,
     -            'LOW*ER_LIMIT'   , 'UP*PER_LIMIT'   /
      DATA SLMTAB/'TICK'           , 'EXACT'          /


 100  IF (LENSTR(LINE).GT.0) THEN
        CALL FNDPAR(LINE,LIMTAB,NELIM,TOKEN,NCT,N)

*** TICKS
        IF (N.EQ.1) THEN
          ILL=TICKV
          IUL=TICKV

*** EXACT
        ELSE IF (N.EQ.2) THEN
          ILL=EXACTV
          IUL=EXACTV

*** LOWER_LIMIT
        ELSE IF (N.EQ.3) THEN
          CALL FNDPAR(TOKEN,SLMTAB,NESLM,TOKEN(1:IFN),NCT,NN)
          IF (NN.EQ.1) THEN
            ILL=TICKV
          ELSE IF (NN.EQ.2) THEN
            ILL=EXACTV
          END IF

*** UPPER_LIMIT
        ELSE IF (N.EQ.4) THEN
          CALL FNDPAR(TOKEN,SLMTAB,NESLM,TOKEN(1:IFN),NCT,NN)
          IF (NN.EQ.1) THEN
            IUL=TICKV
          ELSE IF (NN.EQ.2) THEN
            IUL=EXACTV
          END IF

***
        END IF

      GO TO 100
      END IF


      RETURN

      END
