*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE CENSYM (IX, IY, SYMBOL)
*
*
* Purpose:
*     Plot a centered character
*
*
* Description:
*     This subroutine plots a character, centered at a given point.
*     In centering the character, lower case letters are offset
*     differently than other characters.
*
*
* Parameters:
* I ->  IX     - X coordinate of the plot location
* I ->  IY     - Y coordinate of the plot location
* C ->  SYMBOL - Character variable specifying the character to be
*                plotted.  The character size must be set to the
*                desired size before calling this routine.
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:30:22 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE CENSYM (IX, IY, SYMBOL)


      INTEGER IX,IY
      INTEGER IW,IH
      INTEGER IXOFFS,IYOFFS

      REAL H,ANG

      CHARACTER*1 SYMBOL
      CHARACTER*1 SYMUP


* Offset the character position (different for lowercase letters)
      CALL GETCHR(IW,IH,ANG)
      CALL UPCSTR(SYMBOL,SYMUP)
      IF (SYMBOL.NE.SYMUP) THEN
        H=0.6666666667*IH
      ELSE
        H=IH
      END IF
      CALL ROTPTC(0.5*IW,0.5*H,ANG,IXOFFS,IYOFFS)

* Plot the character
      CALL PLCHAR(IX-IXOFFS,IY-IYOFFS,SYMBOL)


      RETURN

      END
