*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE LABEL (VAL, NPL, CBUFF, NC)
*
*
* Purpose:
*     Convert a real value to a string
*
*
* Description:
*     This subroutine converts an input value to a representation with
*     a maximum of NPL characters.  Trailing nonsignificant zeros and
*     periods as well as leading blanks are removed.  One character
*     position is reserved for the sign.
*
*     Depending on the magnitude of the input value, the output string
*     is coded using one of the following formats.  Define A to be the
*     magnitude of the input value.
*     1) 10**(NPL-1) < A
*        The output field is filled with NPL asterisks (*).
*     2) 10**(NPL-2) < A < 10**(NPL-1)
*        The value is represented in integer format with NPL-1 digits
*        without a decimal point, with a sign if the value is negative.
*     3) 1 < A < 10**(NPL-2).
*        The value is represented with at most NPL-2 significant
*        digits, possibly with a decimal point and a sign (if the value
*        is negative).
*     4) A < 1
*        The value is represented in fixed point notation with NPL-3
*        decimal places with a possible leading zero, decimal point and
*        sign (if the value is negative).
*
*
* Parameters:
* R ->  VAL    - Input value to be coded
* I ->  NPL    - Maximum number of characters in the representation
*                (maximum 7)
* C <-  CBUFF  - Output character string.  CBUFF can contain up to NPL
*                characters.
* I <-  NC     - Number of significant characters in CBUFF
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:27:59 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE LABEL (VAL, NPL, CBUFF, NC)


      INTEGER NPL,NC
      INTEGER K,I
      INTEGER LOCNBL

      REAL VAL
      REAL AV

      CHARACTER CBUFF*(*)
      CHARACTER*14 CWORK
      CHARACTER*7 CSTAR,FMTSTR

      DATA CSTAR/'*******'/


* Determine which region applies
      AV=ABS(VAL)
      IF (AV.LT.1.0) THEN

* Encode the value using an F format
        WRITE (UNIT=FMTSTR,FMT=3000) NPL-3
        WRITE (UNIT=CWORK,FMT=FMTSTR) VAL

      ELSE IF (AV.LT.10.**(NPL-2)-0.5) THEN

* Encode the value using a G format
        WRITE (UNIT=FMTSTR,FMT=3100) NPL-2
        WRITE (UNIT=CWORK,FMT=FMTSTR) VAL

      ELSE IF (AV.LT.10.**(NPL-1)-0.5) THEN

* Encode the value using a G format
        WRITE (UNIT=FMTSTR,FMT=3100) NPL-1
        WRITE (UNIT=CWORK,FMT=FMTSTR) VAL

      ELSE

* VAL is too large
        CWORK=CSTAR(1:NPL)

      END IF

* Strip off trailing blanks, zeros and periods
      DO 500 K=14,1,-1
        IF (CWORK(K:K).NE.'0' .AND. CWORK(K:K).NE.' ') GO TO 550
 500  CONTINUE
 550  IF (CWORK(K:K).EQ.'.') K=K-1

* Strip off leading blanks
      I=LOCNBL(CWORK(1:K))

      CBUFF=CWORK(I:K)
      NC=K-I+1
      IF (NC.GT.LEN(CBUFF)) THEN
        CALL WARN('LABEL - String truncated')
        NC=LEN(CBUFF)
      END IF


      RETURN

 3000 FORMAT ('(F14.',I1,')')
 3100 FORMAT ('(G14.',I1,')')

      END
