*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE FNDSCL (FMIN, FMAX, MINLEN, MAXLEN, LENAX, FV, DV)
*
*
* Purpose:
*     Find the axis intervals for a plot
*
*
* Description:
*     This routine chooses an axis suitable for plotting a range of
*     data.  The axis is specified by the number of axis intervals, the
*     axis starting value and the increment for each interval.
*
*     A scaling based on the maximum axis length is chosen.  Any
*     excess intervals at the ends are trimmed, but leaving at least
*     the minimum number of axis intervals.  The number of intervals
*     chosen is made even, subject to the constrains of the minimum
*     and maximum number of intervals.  (An even number of intervals
*     gives an odd number of ticks; often only every second tick is
*     labelled.)  If there are unused intervals, the axis is shifted
*     to either place zero at either end or to try to make the axis
*     more symmetrical about zero.
*
*
* Parameters:
* R ->  FMIN   - Minimum data value
* R ->  FMAX   - Maximum data value
* I ->  MINLEN - Minimum number of axis intervals (intervals between
*                axis tick marks)
* I ->  MAXLEN - Maximum number of axis intervals
* I <-  LENAX  - Number of axis intervals used.  This value will be
*                less than or equal to MAXLEN.  This value is even if
*                possible.
* R <-  FV     - Data value corresponding to the start of the axis
* R <-  DV     - Number of data units per axis interval
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:27:56 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE FNDSCL (FMIN, FMAX, MINLEN, MAXLEN, LENAX, FV, DV)


      REAL EPS
      PARAMETER (EPS=1E-4)

      INTEGER MINLEN,MAXLEN,LENAX
      INTEGER L

      REAL FMIN,FMAX,FV,DV


* Choose an axis scale
      CALL SCALE(FMIN,FMAX,REAL(MAXLEN),FV,DV)
      LENAX=(FMAX-FV)/DV+(1.-EPS)

      IF (MOD(LENAX,2).NE.0) LENAX=LENAX+1
      IF (LENAX.LT.MINLEN) LENAX=MINLEN
      IF (LENAX.GT.MAXLEN) LENAX=MAXLEN

* Adjust the axis to have the origin at the lower edge
      IF (FMIN.GE.0.0 .AND. FMAX.LE.(LENAX+EPS)*DV) THEN
        FV=0.0

* Adjust the axis to have the origin at the upper edge
      ELSE IF (FMAX.LE.0.0 .AND. FMIN.GE.-(LENAX+EPS)*DV) THEN
        FV=-LENAX*DV

* Centre the axis
      ELSE
        L=NINT(0.5*( ( FV+LENAX*DV-FMAX)-(FMIN-FV) )/DV )
        FV=FV-L*DV

      END IF


      RETURN

      END
