*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE DRWVAX (IX0, IY0, LENY, YMIN, YMAX,
*                        ATICK, ALABEL, NTICK, IFN)
*
*
* Purpose:
*     Draw a labelled vertical axis
*
*
* Description:
*     A vertical axis with tick marks to mark intervals is drawn from
*     the given origin.  This routine uses the character size in effect
*     to determine the character size for the labels.  In addition,
*     axis tick marks scale with the width of the characters.
*
*
* Parameters:
* I ->  IX0    - X coordinate of the start of the axis (plotting units)
* I ->  IY0    - Y coordinate of the start of the axis (plotting units)
* I ->  LENY   - Length of the axis (plotting units)
* R ->  YMIN   - Data value corresponding to the start of the axis
*                (data units)
* R ->  YMAX   - Data value corresponding to the end of the axis
*                (data units)
* R ->  ATICK  - Array of data values at which ticks are to be placed.
*                If a data value lies outside the range spanned by the
*                axis [YMIN to YMAX], the corresponding tick is not
*                drawn.
* C ->  ALABEL - Character array of labels to be placed beside the tick
*                marks.  The labels are centered beside the ticks.  For
*                the purpose of determining the length of the label,
*                a null character if present, marks the end of the
*                string.  The label array is in one-to-one
*                correspondence with the array of tick locations.
* I ->  NTICK  - The absolute value of NTICK is the number of ticks
*                specified in ATICK.  If NTICK is positive, the
*                corresponding labels are drawn above or below the
*                ticks. If NTICK is negative, only the ticks are drawn.
* I ->  IFN    - Control variable,
*                   Positive - Axis ticks are drawn to the right of the
*                              axis.  Labels are drawn to the left of
*                              the axis.
*                   Zero -     Axis ticks are drawn on both sides of
*                              the axis.  Labels are drawn to the left
*                              of the axis.
*                   Negative - Axis ticks are to the left of the axis.
*                              Labels are drawn to the right of the
*                              axis.
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.5 $  $Date: 1995/03/08 15:27:50 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE DRWVAX (IX0, IY0, LENY, YMIN, YMAX,
     -                   ATICK, ALABEL, NTICK, IFN)


      REAL W0,W1,XSP0,XSP1
      PARAMETER (W0=0.5,W1=0.75,XSP0=1.0,XSP1=1.5)

      INTEGER IX0,IY0,LENY,NTICK,IFN
      INTEGER IW,IH,IW0,IW1,IXS0,IXS1,IXL0,IXR0,IXL1,IXR1,
     -        ICENT,IX,I,IY,NC
      INTEGER LENNUL

      REAL YMIN,YMAX
      REAL ATICK(*)
      REAL ANG,PVY

      CHARACTER*(*) ALABEL(*)


* Draw the axis
      CALL XYVECT(IX0,IY0,IX0,IY0+LENY)

* Determine the offsets for ticks
* IXL0 and IXL0 are used for unlabelled ticks, while
* IXR1 and IXR1 are used for labelled ticks
      CALL GETCHR(IW,IH,ANG)
      CALL SETCHR(IW,IH,0.0)
      IW0=NINT(W0*IW)
      IW1=NINT(W1*IW)
      IXS0=NINT(XSP0*IW)
      IXS1=NINT(XSP1*IW)
      IF (IFN.GT.0) THEN
        IXL0=0
        IXR0=+IW0
        IXL1=0
        IXR1=+IW1
        ICENT=7
        IX=-IXS0
      ELSE IF (IFN.LT.0) THEN
        IXL0=-IW0
        IXR0=0
        IXL1=-IW1
        IXR1=0
        ICENT=1
        IX=+IXS0
      ELSE
        IXL0=-IW0
        IXR0=+IW0
        IXL1=-IW1
        IXR1=+IW1
        ICENT=7
        IX=-IXS1
      END IF


      PVY=LENY/(YMAX-YMIN)
      DO 100 I=1,ABS(NTICK)

        IY=NINT((ATICK(I)-YMIN)*PVY)
        IF (IY.GE.0 .AND. IY.LE.LENY) THEN

* Find the length of the label string
          NC=LENNUL(ALABEL(I))
          IF (NC.GT.0) THEN

* Labelled ticks
* Right or left justify the label beside the tick
            CALL XYVECT(IX0+IXL1,IY0+IY,IX0+IXR1,IY0+IY)
            IF (NTICK.GT.0) THEN
              CALL PLTEXT(IX0+IX,IY0+IY,ICENT,ALABEL(I)(1:NC))
            END IF

          ELSE

* Unlabelled ticks
            CALL XYVECT(IX0+IXL0,IY0+IY,IX0+IXR0,IY0+IY)

          END IF
        END IF

 100  CONTINUE

* Restore the character angle
      CALL SETCHR(IW,IH,ANG)


      RETURN

      END
