*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE DRWHAX (IX0, IY0, LENX, XMIN, XMAX,
*                        ATICK, ALABEL, NTICK, IFN)
*
*
* Purpose:
*     Draw a labelled horizontal axis
*
*
* Description:
*     A horizontal axis with tick marks to mark intervals is drawn from
*     the given origin.  This routine uses the character size in effect
*     to determine the character size for the labels.  In addition,
*     axis tick marks scale with the height of the characters.
*
*
* Parameters:
* I ->  IX0    - X coordinate of the start of the axis (plotting units)
* I ->  IY0    - Y coordinate of the start of the axis (plotting units)
* I ->  LENX   - Length of the axis (plotting units)
* R ->  XMIN   - Data value corresponding to the start of the axis
*                (data units)
* R ->  XMAX   - Data value corresponding to the end of the axis
*                (data units)
* R ->  ATICK  - Array of data values at which ticks are to be placed.
*                If a data value lies outside the range spanned by the
*                axis [XMIN to XMAX], the corresponding tick is not
*                drawn.
* C ->  ALABEL - Character array of labels to be placed beside the tick
*                marks.  The labels are centered above or below the
*                ticks.  For the purpose of determining the length of
*                the label, a null character if present, marks the end
*                of the string.  The label array is in one-to-one
*                correspondence with the array of tick locations.  Even
*                for an unlabelled axis,  whether a label has zero
*                length or not affects the size of the corresponding
*                axis tick.
* I ->  NTICK  - The absolute value of NTICK is the number of ticks
*                specified in ATICK.  If NTICK is positive, the
*                corresponding labels are drawn above or below the
*                ticks. If NTICK is negative, only the ticks are drawn.
* I ->  IFN    - Control variable,
*                   Positive - Axis ticks are drawn above the axis.
*                              Labels are drawn below the axis.
*                   Zero -     Axis ticks are drawn on both sides of
*                              the axis.  Labels are drawn below the
*                              axis.
*                   Negative - Axis ticks are drawn below the axis.
*                              Labels are drawn above the axis.
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:27:47 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE DRWHAX (IX0, IY0, LENX, XMIN, XMAX,
     -                   ATICK, ALABEL, NTICK, IFN)


      REAL W0,W1,YSP
      PARAMETER (W0=0.3333333333,W1=0.5,YSP=0.8333333333)

      INTEGER IX0,IY0,LENX,NTICK,IFN
      INTEGER IW,IH,IW0,IW1,IYS,IYD0,IYU0,IYD1,IYU1,
     -        ICENT,IY,I,IX,NC
      INTEGER LENNUL

      REAL XMIN,XMAX
      REAL ATICK(*)
      REAL ANG,PVX

      CHARACTER*(*) ALABEL(*)


* Draw the axis
      CALL XYVECT(IX0,IY0,IX0+LENX,IY0)

* Determine the offsets for ticks and labels
* IYD0 and IYU0 are used for unlabelled ticks, while
* IYD1 and IYU1 are used for labelled ticks
      CALL GETCHR(IW,IH,ANG)
      CALL SETCHR(IW,IH,0.0)
      IW0=NINT(W0*IH)
      IW1=NINT(W1*IH)
      IYS=NINT(YSP*IH)
      IF (IFN.GT.0) THEN
        IYD0=0
        IYU0=+IW0
        IYD1=0
        IYU1=+IW1
        ICENT=5
        IY=-IYS
      ELSE IF (IFN.LT.0) THEN
        IYD0=-IW0
        IYU0=0
        IYD1=-IW1
        IYU1=0
        ICENT=3
        IY=+IYS
      ELSE
        IYD0=-IW0
        IYU0=+IW0
        IYD1=-IW1
        IYU1=+IW1
        ICENT=5
        IY=-IYS
      END IF


      PVX=LENX/(XMAX-XMIN)
      DO 100 I=1,ABS(NTICK)

        IX=NINT((ATICK(I)-XMIN)*PVX)
        IF (IX.GE.0 .AND. IX.LE.LENX) THEN

* Find the length of the label string
          NC=LENNUL(ALABEL(I))
          IF (NC.GT.0) THEN

* Labelled ticks
* Centre the label string above or below the tick
            CALL XYVECT(IX0+IX,IY0+IYD1,IX0+IX,IY0+IYU1)
            IF (NTICK.GT.0)
     -        CALL PLTEXT(IX0+IX,IY0+IY,ICENT,ALABEL(I)(1:NC))

          ELSE

* Unlabelled ticks
            CALL XYVECT(IX0+IX,IY0+IYD0,IX0+IX,IY0+IYU0)

          END IF

        END IF

 100  CONTINUE

* Restore the character angle
      CALL SETCHR(IW,IH,ANG)


      RETURN

      END
