*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE VTXY (IX, IY, LWIDTH)
*
*
* Purpose:
*     Write a ReGIS display vector
*
*
* Description:
*     This routine accepts a pair of X-Y coordinates as input.  A
*     string of ReGIS commands in constructed which is then sent to
*     the terminal.
*
*
* Parameters:
* I ->  IX     - X coordinate in plotting units (0 to 4095)
* I ->  IY     - Y coordinate in plotting units (0 to 4095)
* I ->  LWIDTH - Line width (plot units).  A zero width line indicates
*                an invisible line.
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:30:11 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE VTXY (IX, IY, LWIDTH)


      INTEGER DARK,VIS
      PARAMETER (DARK=0,VIS=1)

      INTEGER IX,IY,LWIDTH

* ReGIS parameters
      INTEGER IXOFF,IXMUL,IXDIV,IYOFF,IYMUL,IYDIV
      PARAMETER (IXOFF=80,IXMUL=5,IXDIV=32,
     -           IYOFF=480,IYMUL=-5,IYDIV=32)

      INTEGER LUNVT
      CHARACTER*255 FNAMVT
      COMMON /VTCOM/ LUNVT,FNAMVT


      IF (LWIDTH.NE.0) THEN
        CALL VTVECT(LUNVT,IX*IXMUL/IXDIV+IXOFF,
     -                    IY*IYMUL/IYDIV+IYOFF,VIS)
      ELSE
        CALL VTVECT(LUNVT,IX*IXMUL/IXDIV+IXOFF,
     -                    IY*IYMUL/IYDIV+IYOFF,DARK)
      END IF


      RETURN

      END
