*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE VTVECT (LUN, IX, IY, IVIS)
*
*
* Purpose:
*     Draw a vector on a ReGIS display
*
*
* Description:
*     This routine accepts a pair of X-Y coordinates as input.  A
*     string of ReGIS commands in constructed which is then sent to
*     the terminal.  The code used tries to compact the sequence of
*     commands by using shortened commands for vertical and horizontal
*     vectors.  This means that the previous position is stored
*     internally.  This previous position can be initialized at the
*     beginning of plotting by a call to VTVECT(LUN,0,0,0).
*
*
* Parameters:
* I ->  LUN    - Unit number for the terminal
* I ->  IX     - X coordinate, 0 to 799 inclusive
* I ->  IY     - Y coordinate, 0 to 479 inclusive
* I ->  IVIS   - Visibility flag,
*                0 - Draw a dark vector to the point indicated
*                1 - Draw a visible vector to the point indicated.  It
*                    is assumed that a dark vector has been drawn
*                    previously.
*
*
* Author / revision:
*     D. Sloan / P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:30:08 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE VTVECT (LUN, IX, IY, IVIS)


      INTEGER MAXLEN,MAXCOM
      PARAMETER (MAXLEN=10,MAXCOM=2*MAXLEN+6)

      INTEGER LUN,IX,IY,IVIS
      INTEGER N,NC
      INTEGER IXOLD,IYOLD,IVPT

      CHARACTER COMMDS*(MAXCOM)

      SAVE IXOLD,IYOLD,IVPT


* Initialize the context
      IF (IX.EQ.0 .AND. IY.EQ.0 .AND. IVIS.EQ.0) THEN
        IXOLD=-1
        IYOLD=-1
        IVPT=0
      END IF

* Position for IVIS=0 (dark), Vector for IVIS=1 (visible)
      IF (IVIS.EQ.0) THEN
        N=2
        COMMDS(1:2)='P['
        IVPT=0
      ELSE

* This code makes sure that the PEL at the start of the first segment
* of a series of visible vectors is turned on.
* Some (if not all) VT240's do not turn on the PEL corresponding to the
* start of a vector.  In this code, that PEL is turned on by drawing a
* vector from the current position to the current position.
        IF (IVPT.GT.0) THEN
          N=2
          COMMDS(1:2)='V['
        ELSE
          N=4
          COMMDS(1:4)='V[]['
        END IF
        IVPT=IVPT+1
      END IF


* Construct the coordinates
* Problems occur if the coordinate is negative, since a coordinate with
* an explicit sign invokes a relative move.  In that case, the correct
* relative move is used.
      IF (IX.NE.IXOLD) THEN
        IF (IX.GE.0) THEN
          CALL CONVIC(IX,COMMDS(N+1:),NC)
          N=N+NC
        ELSE IF (IX-IXOLD.LT.0) THEN
          CALL CONVIC(IX-IXOLD,COMMDS(N+1:),NC)
          N=N+NC
        ELSE
          N=N+1
          COMMDS(N:N)='+'
          CALL CONVIC(IX-IXOLD,COMMDS(N+1:),NC)
          N=N+NC
        END IF
        IXOLD=IX
      END IF

      N=N+1
      COMMDS(N:N)=','
      IF (IY.NE.IYOLD) THEN
        IF (IY.GE.0) THEN
          CALL CONVIC(IY,COMMDS(N+1:),NC)
          N=N+NC
        ELSE IF (IY-IYOLD.LT.0) THEN
          CALL CONVIC(IY-IYOLD,COMMDS(N+1:),NC)
          N=N+NC
        ELSE
          N=N+1
          COMMDS(N:N)='+'
          CALL CONVIC(IY-IYOLD,COMMDS(N+1:),NC)
          N=N+NC
        END IF
        IYOLD=IY
      END IF

      N=N+1
      COMMDS(N:N)=']'

* Send the buffer to the terminal
      WRITE (UNIT=LUN,FMT=1200) COMMDS(1:N)


      RETURN

 1200 FORMAT (A)

      END
