*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE VTINIT (OPTION)
*
*
* Purpose:
*     Initialize a plot on a ReGIS display
*
*
* Description:
*     This subroutine (optionally) clears the screen of the terminal
*     and draws a dark vector.
*
*
* Parameters:
* C ->  OPTION - Character string specifying the options.  Options are
*                separated by commas and/or whitespace (blanks, tabs,
*                or nulls).  If any option is omitted, the default
*                value is used.  An all blank string gives the default
*                values.  The same keyword may appear more than once,
*                with the last instance taking precedence.  The CLEAR
*                and OVERLAY options apply only to one invokation of
*                this routine.
*                CLEAR - The screen is erased.  CLEAR is the default
*                  option if this plot device is not active.
*                OVERLAY - The screen is not erased.  OVERLAY is the
*                  default option if this plot device is already
*                  active.
*                FILENAME=name - Specifies the name of the file or
*                  terminal to which plot data is sent.  The file name
*                  is not used if this plot device is already active.
*                  The special file name "*" can be  used to direct
*                  output to the standard output (Fortran unit 6).  The
*                  default file name is "/dev/tty".
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.5 $  $Date: 1995/03/08 15:30:05 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE VTINIT (OPTION)


      CHARACTER*(*) ERASE
      INTEGER DARK,ESC,NEKEY
      PARAMETER (DARK=0,ESC=27,ERASE='S(E)')
      PARAMETER (NEKEY=3)

      INTEGER NC,N,NCN
      INTEGER LENSTR

      CHARACTER*(*) OPTION
      CHARACTER*256 LINE,TOKEN
      CHARACTER*20 KEYTAB(NEKEY)
      CHARACTER*1 CESC

      LOGICAL CLEAR

      INTEGER LUNVT
      CHARACTER*255 FNAMVT
      COMMON /VTCOM/ LUNVT,FNAMVT
      DATA LUNVT/-1/,FNAMVT/'/dev/tty'/

      DATA KEYTAB/'CL*EAR'         , 'OVER*LAY'        ,
     -            'FILE*NAME'      /


      CLEAR=(LUNVT.LT.0)
      CALL RQUOTE(OPTION,LINE,NC)

* Decode the options
 100  IF (LENSTR(LINE).GT.0) THEN
        CALL FNDPAR(LINE,KEYTAB,NEKEY,TOKEN,NC,N)

        IF (N.EQ.1) THEN
          CLEAR=.TRUE.

        ELSE IF (N.EQ.2) THEN
          CLEAR=.FALSE.

        ELSE IF (N.EQ.3) THEN
          CALL RQUOTE(TOKEN(1:NC),FNAMVT,NCN)

        END IF

      GO TO 100
      END IF


      IF (LUNVT.LT.0) THEN

* Not previously selected
* Open the file
        IF (FNAMVT.EQ.'*') THEN
          LUNVT=6
        ELSE
          CALL FBAKUP(FNAMVT)
          CALL GETFUN(LUNVT)
          OPEN (UNIT=LUNVT,FILE=FNAMVT,STATUS='UNKNOWN')
        END IF

        CESC=CHAR(ESC)
        WRITE (UNIT=LUNVT,FMT=1000) CESC//'P'//
     -                              '1pS(A[0,0][799,479])'
        IF (CLEAR) WRITE (UNIT=LUNVT,FMT=1000) ERASE
        CALL VTVECT(LUNVT,0,0,0)

      ELSE IF (CLEAR) THEN

* Previously selected, with CLEAR option
        WRITE (UNIT=LUNVT,FMT=1000) ERASE

      END IF


      RETURN

 1000 FORMAT (A)

      END
