*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE VTEND
*
*
* Purpose:
*     Terminate a plot on a ReGIS display
*
*
* Description:
*     This subroutine exits ReGIS mode with the text cursor placed at
*     the home position.  The routine then closes the plotting unit.
*
*
* Parameters:
*     None
*
*
* Author / revision:
*     D. Sloan / P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:29:59 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE VTEND


      INTEGER ESC,BSLASH
      PARAMETER (ESC=27,BSLASH=92)

      CHARACTER*1 CESC,CBSL

      INTEGER LUNVT
      CHARACTER*255 FNAMVT
      COMMON /VTCOM/ LUNVT,FNAMVT


* Exit Regis
      CESC=CHAR(ESC)
      CBSL=CHAR(BSLASH)
      WRITE (UNIT=LUNVT,FMT=1000) CESC//CBSL//CESC//'8'

* Close the unit
      IF (LUNVT.NE.6) THEN
        CLOSE (UNIT=LUNVT)
        CALL RELFUN(LUNVT)
      END IF

* Set the common area parameters to their default values
      LUNVT=-1
      FNAMVT='/dev/tty'


      RETURN

 1000 FORMAT (A)

      END
