*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE UNXY (IX, IY, LWIDTH)
*
*
* Purpose:
*     Send a vector to a Unix plot file
*
*
* Description:
*     This routine writes a plot vector to a Unix plot file.
*
*
* Parameters:
* I ->  IX     - X coordinate in plotting units (0 to 4095)
* I ->  IY     - Y coordinate in plotting units (0 to 4095)
* I ->  LWIDTH - Line width (plot units).  A zero width line indicates
*                an invisible line.
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.5 $  $Date: 1995/03/08 15:29:57 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE UNXY (IX, IY, LWIDTH)


      INTEGER IX,IY,LWIDTH
      INTEGER IBO
      INTEGER*2 ICOORD(2)
      INTEGER IBYORD

      INTEGER LUNUN
      CHARACTER*255 FNAMUN
      COMMON /UNCOM/ LUNUN,FNAMUN


* Write the command
      IF (LWIDTH.NE.0) THEN
        CALL FPUTCN(LUNUN,'n')
      ELSE
        CALL FPUTCN(LUNUN,'m')
      END IF

* Write the coordinates in binary format (machine-dependent byte order)
      ICOORD(1)=IX
      ICOORD(2)=IY
      IBO=IBYORD()
      CALL FPUTI2(LUNUN,ICOORD,2,IBO)


      RETURN

      END
